<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\StockTransaction;
use Carbon\Carbon;
use App\Service\StaticMaster;
use App\Service\ActivityService;
use App\Service\StockEntryService;
use Log;

class StockTransactionController extends Controller
{
    public function saveStockEntries(Request $request){
        
         // Validate Item
        $validator=validator($request->all(),[
            'inout'=>'required',
            'warehouse_id'=>'required',
            'fy'=>'required',
            'quantity'=>'required',
            'item_id'=>'required',
            'transaction_date'=>'required'
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];
        } else {
           
            $obj = array();
            $obj['item_id']=$request['item_id'];
            $obj['warehouse_id']=$request['warehouse_id']==null?0:$request['warehouse_id'];
            $obj['zone_id']=$request['zone_id']==null?0:$request['zone_id'];
            $obj['rack_id']=$request['rack_id']==null?0:$request['rack_id'];
            $obj['bin_id']=$request['bin_id']==null?0:$request['bin_id'];
            $obj['transaction_date']=$request['transaction_date'];
            $obj['unit_id']=$request['unit_id'];
            $obj['transaction_id']=0;
            $obj['inout']=$request['inout']??0;
            $obj['updatestatus']=0;
            $obj['quantity']=$request['quantity'];
            $obj['transaction_type']=StaticMaster::$MODIFY_STOCK;
            $obj['fy']=$request['fy'];
            $obj['reason_type']=$request['reason_type'];  //master data
            $obj['account_id']=$request['account_id'];  //from the accounts table
            $obj['reference_no']=$request['reference_no'];  
            $obj['description']=$request['description'];  
            $obj['attachment']=$request['attachment'];  
            $obj['image_url']=$request['image_url'];  

            $stock = StockTransaction::create($obj);

            $stockService=new StockEntryService;
            $stockService->addItemStock($stock,$request['item_id'],$request['inout'],$request['quantity']);

            // Creating Activities
            $activity=new ActivityService;
            $activity->activityCreateUpdate('Item Stock',$stock['id'],'Created');
            
            // $dailyService = new DailyService; 
            // $dailyService->updateNextDayStockStatus($obj);
            
            $response=[
                'success'=>true,
                'stock'=>$stock,
                'message'=>"Item added to stock's history successfully."
            ];
        }

        return response()->json($response);
        
    }

    // Stock Transfer Form one Warehouse to another
    public function stockTransferForm(Request $request){
        
        $validator=validator($request->all(),[
            'item_id'=>'required|integer',
            'fy'=>'required'
        ]);

        if ($validator->fails()) { 

            return [
                'success' => false, 
                'message' => $validator->errors()->first(),
                'items_details' => null
            ];

        } else {
            $obj = array();

            // For OUT Stock Transfer
            $obj['unit_id']=$request['unit_id']??0;
            $obj['item_id']=$request['item_id']??0;
            $obj['transaction_date']=$request['transaction_date'];
            $obj['goods_condition_type']=$request['goods_condition_type']??1;
            $obj['updatestatus']=1;
            $obj['quantity']=$request['quantity']??0;
            $obj['transaction_type']=StaticMaster::$STOCK_TRANSFER_TYPE;
            $obj['fy']=$request['fy']??Carbon::now()->year;
            $obj['description']=$request['description'];  
            $obj['attachment']=$request['attachment']; 
            $obj['reason_type']=$request['reason_type']??0; 
        
            $obj['warehouse_id']=$request['from_warehouse_id']??0;
            $obj['zone_id']=$request['from_zone_id']??0;
            $obj['rack_id']=$request['from_rack_id']??0;
            $obj['bin_id']=$request['from_bin_id']??0;
            $obj['inout']=2;     //inout=2 for out and //inout=1 in
        
            $stock_transaction = StockTransaction::create($obj);

            // For IN Stock Transfer
            $obj['warehouse_id']=$request['to_warehouse_id']??0;
            $obj['zone_id']=$request['to_zone_id']??0;
            $obj['rack_id']=$request['to_rack_id']??0;
            $obj['bin_id']=$request['to_bin_id']??0;
            $obj['inout']=1;     //inout=2 for out and //inout=1 in

            $stock_transaction = StockTransaction::create($obj);

            return [
                'success' => true, 
                'message' => 'Stock Transfer created successfully.'
            ];
        }
        
    }
}
