<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\ExpenseHead;
use App\Models\TaxRate;
use Auth;
use App\Service\ActivityService;

class TaxRateController extends Controller
{

    // Creating and Updating taxrate .
    public function createTaxRate(Request $request){
         // Validation user and name  of organisation
         $validator=validator($request->all(),[
            'tax_percentge'=>'required',
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];
        } else {
            $obj['tax_type']=$request['tax_type'];  
            $obj['tax_name']=$request['tax_name'];
            $obj['tax_percentge']=$request['tax_percentge'];
            $obj['is_value_added']=$request['is_value_added'];
            $obj['is_value_added']=$request['is_value_added'];

            if($request['id']>0)   // update existing record
            {
                try{
                    $tax_rate=TaxRate::findOrFail($request['id']);

                    if($tax_rate['is_editable']==1){

                        $tax_rate->update($obj);

                    }

                    // Creating Activities
                    // $activity=new ActivityService;
                    // $activity->activityCreateUpdate('Expense head',$expense_head['id'],'Updated');

                } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
                    // Return error message in JSON if ID not found
                    return response()->json(['message' => 'Invalid Id to update '], 404);
                }
            }else {
                // create new Expense Head
                $check = TaxRate::where('tax_percentge',$request->tax_percentge)->first();

                if($check !=null){

                    $response=[
                        "data"=>$check,
                        "success"=>false,
                        "message"=>"TaxRate Already added",
                    ];

                    return response()->json($response);

                }else{

                    $tax_rate=TaxRate::create($obj);

                }

                // Creating Activities
                // $activity=new ActivityService;
                // $activity->activityCreateUpdate('Expense Head',$expense_head['id'],'Created');
            }

            $response=[
                "data"=>$tax_rate,
                "success"=>true,
                "message"=>"TaxRate Saved Successfully",
            ];

            return response()->json($response);
        }
    }

    public function  listTaxRate(){
        $user=Auth::user();

        // Log::info($user['active_organisation']);

        $tax_rate = TaxRate::where('organisation_id', null)
                                ->orWhere('organisation_id', $user['active_organisation'])
                                ->get();

        $response = ["data" => $tax_rate,"success" => true];

        return response()->json($response);
    }

    public function deleteTaxRate(Request $request){
        $validator=validator($request->all(),[
            'id'=>'required',
        ]);
        if ($validator->fails()) {
            return [
                'success' => false,
                'message' => $validator->errors()->first()
            ];
        } else {
            try{
                $tax_rate=TaxRate::findOrFail($request['id']);
                $tax_rate->delete();
            } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
                // Return error message in JSON if ID not found
                return response()->json(['message' => 'Invalid Id to delete '], 404);
            }
            $response=[
                "success"=>true,
                "message"=>"TaxRate Deleted Successfully",
            ];
            return response()->json($response);
        }
    }

}
