<?php

namespace App\Http\Controllers\Api\Tms;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Tms\TyreStock;
use DB;

class DashboardController extends Controller
{
    //Creating a total record of the Tyre
    public function totalTyreReport(Request $request)
    {
        // calculating Tread dept
        $total_tyre=TyreStock::where('status','Active');
            // ->count();

        // Location Store Total Tyre
        $location_store=TyreStock::where('status','Active')
            ->where('location_status','Store');
            // ->count();

        //Location on Service
        $location_service=TyreStock::where('status','Active')
            ->where('location_status','Service');
            // ->count()

        //Location on Scrap
        $location_scrap=TyreStock::where('status','Active')
            ->where('location_status','Scrap');
            // ->count();

             // Location on Vehicle 
        $location_vehicle=TyreStock::where('status','Active')
            ->where('location_status','Vehicle');
            // ->count();
        
        //Location on Trailer
        $location_trailer=TyreStock::where('status','Active')
            ->where('location_status','Trailer');

        if($request['brand']!=null && $request['brand']!=''){
            $total_tyre=$total_tyre->where('brand','like','%'.$request['brand'].'%');
            $location_store=$location_store->where('brand','like','%'.$request['brand'].'%');
            $location_service=$location_service->where('brand','like','%'.$request['brand'].'%');
            $location_scrap=$location_scrap->where('brand','like','%'.$request['brand'].'%');
            $location_vehicle=$location_vehicle->where('brand','like','%'.$request['brand'].'%');
            $location_trailer=$location_trailer->where('brand','like','%'.$request['brand'].'%');
        }

        $total_tyre=$total_tyre->count();
        $location_store=$location_store->count();
        $location_service=$location_service->count();
        $location_scrap=$location_scrap->count();
        $location_vehicle=$location_vehicle->count();
        $location_trailer=$location_trailer->count();
      
        return response()->json([
            'total_tyre'=>$total_tyre,
            'location_store'=>$location_store,
            'location_service'=>$location_service,
            'location_scrap'=>$location_scrap,
            'location_vehicle'=>$location_vehicle,
            'location_trailer'=>$location_trailer
        ]);
    }

    //tyre installed report
    public function totalTyreInstalledReport(Request $request)
    {
        // Location on Vehicle 
        $location_vehicle=TyreStock::where('status','Active')
            ->where('location_status','Vehicle');
            // ->count();
        
        //Location on Trailer
        $location_trailer=TyreStock::where('status','Active')
            ->where('location_status','Trailer');
            // ->count();

        if($request['brand']!=null && $request['brand']!=''){
            $location_vehicle=$location_vehicle->where('brand','like','%'.$request['brand'].'%');
            $location_trailer=$location_trailer->where('brand','like','%'.$request['brand'].'%');
        }

        $location_vehicle=$location_vehicle->count();
        $location_trailer=$location_trailer->count();

        return response()->json([
            'location_vehicle'=>$location_vehicle,
            'location_trailer'=>$location_trailer
        ]);
    }

    // Tread Depth Report Function
    public function tyreDepthReport(Request $request)
    {
        $tyre_depth = TyreStock::select('tread_depth', DB::raw('count(*) as total'))
            ->where('status', 'Active');

        // Apply filters if given
        if ($request->filled('tread_depth')) {
            $tyre_depth->where('tread_depth', '<=', $request->tread_depth);
        }

        if ($request->filled('brand')) {
            $tyre_depth->where('brand', 'like', '%' . $request->brand . '%');
        }

        // Group by tread_depth
        $tyre_depth = $tyre_depth->groupBy('tread_depth')
            ->orderBy('tread_depth', 'asc')
            ->get();

        return response()->json([
            'message' => 'Successfully fetched tyre depth report',
            'success' => true,
            'data' => $tyre_depth
        ]);
    }

}
