<?php

namespace App\Http\Controllers\Api\Tms;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Tms\Trailer;
use App\Models\Tms\Trailers\TrailerInstallation;
use App\Models\Tms\Trailers\TrailerDocument;
use App\Models\Tms\BatteryStock;
use App\Models\Tms\BatteryHistory;
use App\Models\Tms\TyreStock;
use App\Models\Tms\TyreHistory;
use App\Models\Tms\RimStock;
use App\Models\Tms\RimHistory;
use Maatwebsite\Excel\Facades\Excel;
use App\Imports\Tms\TyreTrailerImport;
use Validator;
use Auth;

class TrailerController extends Controller
{
    // Trailer Create Update
    
    public function trailerCreateUpdate(Request $request){

        $validator = Validator::make($request->all(), [
            'model' => 'required',
            'trailer_id' => 'required',
            'year' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'message' => $validator->errors()->first(),
                'data' => null
            ], 200);
        }

        $obj['trailer_id'] = $request['trailer_id'];
        $obj['trailer_type'] = $request['trailer_type'];
        $obj['manufacturer'] = $request['manufacturer'];
        $obj['model'] = $request['model'];
        $obj['year'] = $request['year'];
        $obj['vin_number'] = $request['vin_number'];
        $obj['registration_number'] = $request['registration_number']; 
        $obj['engine_applicable'] = $request['engine_applicable']??null; 
        $obj['engine_type'] = $request['engine_type']??null; 
        $obj['purchase_date'] = $request['purchase_date']??null;
        $obj['purchase_price'] = $request['purchase_price']??null; 
        $obj['length'] = $request['length']??null ;  
        $obj['width'] = $request['width']??null;
        $obj['height'] = $request['height']??null;
        $obj['gvwr'] = $request['gvwr']??null;
        $obj['axle_tyre_configuration'] = $request['axle_tyre_configuration']??null;
        $obj['axle_configuration'] = $request['axle_configuration']??null;
        $obj['tare_weight'] = $request['tare_weight']??null;
        $obj['payload_capacity'] = $request['payload_capacity']??null;
        $obj['remarks'] = $request['remarks']??null;
        $obj['json_data'] = $request['json_data']??null;
        $obj['trailer_json'] = $request['trailer_json']??null;
        $obj['status'] = $request['status']??null;
        $obj['is_logistics'] = $request['is_logistics']??0;
        $obj['logistic_provider_id'] = $request['logistic_provider_id']??0;

        if($request['id'] > 0){

            try {

                $trailer = Trailer::findOrFail($request['id']);
            
                $trailer->update($obj);

                //Delete Trailer documents
                TrailerDocument::where('trailer_id', $request['id'])->delete();

                //Create new documents
                 if($request['documents'] != null && count($request['documents']) > 0){

                    foreach($request['documents'] as $document){
                        TrailerDocument::create([
                            'trailer_id' => $request['id'],
                            'document_name' => $document['document_name'],
                            'id_number' => $document['id_number'],
                            'issue_date' => $document['issue_date'],
                            'expiry_date' => $document['expiry_date'],
                            'renewal_date' => $document['renewal_date'],
                            'attachments' => $document['attachments'],
                            'remarks' => $document['remarks'],
                        ]);
                    }
                }

                return response()->json([
                    'success' => true,
                    'message' => 'Trailer updated successfully',
                    'data' => $trailer
                ], 200);

            } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
                return response()->json([
                    'success' => false,
                    'message' => 'Vehicle not found',
                    'data' => null
                ], 200);
            }
        } else {
            $trailer = Trailer::create($obj);

            //Create new documents
            if($request['documents'] != null && count($request['documents']) > 0){

                foreach($request['documents'] as $document){
                    TrailerDocument::create([
                        'trailer_id' => $trailer->id,
                        'document_name' => $document['document_name'],
                        'id_number' => $document['id_number'],
                        'issue_date' => $document['issue_date'],
                        'expiry_date' => $document['expiry_date'],
                        'renewal_date' => $document['renewal_date'],
                        'attachments' => $document['attachments'],
                        'remarks' => $document['remarks'],
                    ]);
                }
            }

            return response()->json([
                'success' => true,
                'message' => 'Trailer created successfully',
                'data' => $trailer
            ], 200);
        }
    }
  
    // List of all trailers
    public function trailerList(Request $request){
        $user=Auth::user();
        
        $trailer=Trailer::where('is_disabled',0)
            ->with('logistic_provider');

        if(isset($request['trailer_type']) && $request['trailer_type']!=null && $request['trailer_type']!=''){
            $trailer=$trailer->where('trailer_type',$request['trailer_type']);
        }

        if(isset($request['model']) && $request['model']!=null && $request['model']!=''){
            $trailer=$trailer->where('model',$request['model']);
        }

        if(isset($request['trailer_id']) && $request['trailer_id']!=''){
            $trailer=$trailer->where('trailer_id',$request['trailer_id']);
        }

        if(isset($request['status']) && $request['status']!=''){
            $trailer=$trailer->where('status',$request['status']);
        }

        if(isset($request['make']) && $request['make']!=''){
            $trailer=$trailer->where('make',$request['make']);
        }

        if(isset($request['year']) && $request['year']!=''){
            $trailer=$trailer->where('year',$request['year']);
        }

        if(isset($request['location_status']) && $request['location_status']!=''){
            $trailer=$trailer->where('location_status',$request['location_status']);
        }

        if(isset($request['vin_number']) && $request['vin_number']!=''){
            $trailer=$trailer->where('vin_number',$request['vin_number']);
        }


        if(isset($request['is_logistics']) && $request['is_logistics']!=''){
            $trailer=$trailer->where('is_logistics',$request['is_logistics']);
        }

        if($request['is_megamarket']==1){
            $trailer=$trailer->where('is_logistics',0);
        }

        if($request['is_logistics']==1){
            $trailer=$trailer->where('is_logistics',1);
        }

        if($request['search']!=null && $request['search']!=''){

            $trailer = $trailer->where(function ($query) use ($request) {

                $query->where('trailer_id', 'LIKE', '%' . $request['search'] . '%')
                ->orWhere('model', 'LIKE', '%' . $request['search'] . '%')
                ->orWhere('year', 'LIKE', '%' . $request['search'] . '%')
                ->orWhere('manufacturer', 'LIKE', '%' . $request['search'] . '%')
                ->orWhere('vin_number', 'LIKE', '%' . $request['search'] . '%')
                ->orWhere('registration_number', 'LIKE', '%' . $request['search'] . '%')
                ->orWhere('trailer_type', 'LIKE', '%' . $request['search'] . '%');

            });
        }

        $count=$trailer->count();

        $trailer =$trailer->orderBy('id','desc')
            ->skip($request['noofrec']*($request['currentpage']-1))->take($request['noofrec']??100)
            ->get();

        $response=[
            'success'=>true,
            'total'=>$count,
            'data'=>$trailer
        ];

        return response()->json($response);
    }

    // Trailers Details 
    public function trailerDetails(Request $request)
    {
        try {
            // Validate the request
            $validator = Validator::make($request->all(), [
                'id' => 'required',
            ]);

            if ($validator->fails()) {
                return response()->json([
                    'success' => false,
                    'message' => $validator->errors()->first(),
                    'data' => null
                ], 200);
            }

            // Fetch trailer details
            $trailer = Trailer::with('item','trailer_installations','documents','vehicle','vehicle.vehicle_installations','vehicle.trailer','logistic_provider')
                ->findOrFail($request->id);

            return response()->json([
                'success' => true,
                'message' => 'Trailers details fetched successfully',
                'data' =>$trailer
            ], 200);
        } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
            return response()->json([
                'success' => false,
                'message' => 'Trailers not found',
                'data' => null
            ], 200);
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => 'An unexpected error occurred',
                'error' => $e->getMessage(),
                'data' => null
            ], 200);
        }
    }
    
    // Trailer Installation 
    public function trailerInstallation(Request $request)
    {
        // Validate the request
        $validator = Validator::make($request->all(), [
            'type_id' => 'required',
            'type' => 'required',       // Battery , Tyre , Rim , Stepney Tyre , Stepney Rim , Trailer
            'trailer_id' => 'required',
            'position' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'message' => $validator->errors()->first(),
                'data' => null
            ], 200);
        }

        // Get the current date, time and user
        $date = date('Y-m-d');
        $time = date('H:i:s');
        $user = Auth::user();
        
         // Fetch trailer details
        try {

            $trailer = Trailer::findOrFail($request->trailer_id);

        } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
            return response()->json([
                'success' => false,
                'message' => 'Trailer not found',
                'data' => null
            ], 404);
        }

        // Battery installation
        if($request->input('type') == 'battery') {

            try {

                $battery = BatteryStock::findOrFail($request->input('type_id'));
                
                // Update the battery stock record
                $battery->installation_date = $date;
                $battery->trailer_id = $request->input('trailer_id');
                $battery->location_status = 'Trailer';
                $battery->position = $request['position'];
                $battery->update();

            } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
                return response()->json([
                    'success' => false,
                    'message' => 'Battery not found',
                    'data' => null
                ], 200);
            }

            // Save the trailer battery History record
            $history = new BatteryHistory;
            $history->battery_id = $battery->id;
            $history->date = $date;
            $history->moved_from = 'Store';
            $history->moved_to = 'Trailer';
            $history->trailer_id = $request->input('trailer_id');
            $history->attachment = $request->input("attachment");
            $history->remark = 'Battery installed on trailer ' . $trailer['trailer_id'] . ' at position ' . $request->input('position');
            $history->save();

        }

        // Tyre installation
        if($request->input('type') == 'tyre') {

            try {

                $tyre = TyreStock::findOrFail($request->input('type_id'));

                // Update the tyre stock record
                $tyre->installation_date = $date;
                $tyre->trailer_id = $request->input('trailer_id');
                $tyre->location_status = 'Trailer';
                $tyre->position_on_trailer = $request->input('position');
                $tyre->update();

            } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
                return response()->json([
                    'success' => false,
                    'message' => 'Tyre not found',
                    'data' => null
                ], 200);
            }
            

            // Save the trailer tyre History record
            $history = new TyreHistory;
            $history->tyre_id = $tyre->id;
            $history->date = $date;
            $history->moved_from = 'Store';
            $history->moved_to = 'Trailer';
            $history->trailer_id = $request->input('trailer_id');
            $history->attachment = $request->input("attachment");
            $history->remark = 'Tyre installed on trailer ' . $trailer['trailer_id'] . ' at position ' . $request->input('position');
            $history->save();

        }

        // Rim installation
        if($request->input('type') == 'rim') {

            try {

                $rim = RimStock::findOrFail($request->input('type_id'));
                // Update the rim stock record
                $rim->installation_date = $date;
                $rim->trailer_id = $request->input('trailer_id');
                $rim->location_status = 'Trailer';
                $rim->position_on_trailer = $request->input('position');
                $rim->update();

            } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
                return response()->json([
                    'success' => false,
                    'message' => 'Rim not found',
                    'data' => null
                ], 404);
            }

            // Save the trailer rim History record
            $history = new RimHistory;
            $history->rim_id = $rim->id;
            $history->date = $date;
            $history->moved_from = 'Store';
            $history->moved_to = 'Trailer';
            $history->trailer_id = $request->input('trailer_id');
            $history->attachment = $request->input("attachment");
            $history->remark = 'Rim installed on trailer ' . $trailer['trailer_id'] . ' at position ' . $request->input('position');
            $history->save();

        }

        // Stepney Tyre installation
        if($request->input('type') == 'stepney Tyre') {

            try {

                $stepneyTyre = TyreStock::findOrFail($request->input('type_id'));

                // Update the stepney tyre stock record
                $stepneyTyre->installation_date = $date;
                $stepneyTyre->trailer_id = $request->input('trailer_id');
                $stepneyTyre->location_status = 'Trailer';
                $stepneyTyre->position_on_trailer = $request->input('position');
                $stepneyTyre->update();

            } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
                return response()->json([
                    'success' => false,
                    'message' => 'Stepney Tyre not found',
                    'data' => null
                ], 404);
            }
            

             // Save the trailer tyre History record
            $history = new TyreHistory;
            $history->tyre_id = $tyre->id;
            $history->date = $date;
            $history->moved_from = 'Store';
            $history->moved_to = 'Trailer';
            $history->trailer_id = $request->input('trailer_id');
            $history->attachment = $request->input("attachment");
            $history->remark = 'Added Stepney Tyre to trailer with ID ' . $trailer['trailer_id'] . ' at position ' . $request->input('position');
            $history->save();

        }

        // Stepney Rim installation
        if($request->input('type') == 'stepney Rim') {

             try {

                $rim = RimStock::findOrFail($request->input('type_id'));

            } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
                return response()->json([
                    'success' => false,
                    'message' => 'Rim not found',
                    'data' => null
                ], 404);
            }
            // Update the rim stock record
            $rim->installation_date = $date;
            $rim->trailer_id = $request->input('trailer_id');
            $rim->location_status = 'Trailer';
            $rim->position_on_trailer = $request->input('position');
            $rim->update();

            // Save the trailer rim History record
            $history = new RimHistory;
            $history->rim_id = $rim->id;
            $history->date = $date;
            $history->moved_from = 'Store';
            $history->moved_to = 'Trailer';
            $history->trailer_id = $request->input('trailer_id');
            $history->attachment = $request->input("attachment");
            $history->remark = 'Stepney Rim installed on trailer ' . $trailer['trailer_id'] . ' at position ' . $request->input('position');
            $history->save();
        }

        // Save the trailer installation record         
        $obj['date'] = $date;
        $obj['trailer_id'] = $request->input('trailer_id');
        $obj['type'] = $request->input('type');
        $obj['type_id'] = $request->input('type_id');
        $obj['position'] = $request->input('position');
        $obj['trailer_configuration'] = $trailer->axle_tyre_configuration;
        $installation = TrailerInstallation::create($obj);

        $response = [
            'success' => true,
            'message' => $request['type'] . ' Installation on Trailer created successfully',
            'data' => $installation
        ];

        return response()->json($response, 200);

    }

    //Save Trailer Tyre Configuration
    public function trailerTyreConfiguration(Request $request)
    {
        // Validate the request
        $validator = Validator::make($request->all(), [
            'id' => 'required',
            'axle_tyre_configuration' => 'required',
        ]);

        if ($validator->fails()) {
            return [
                'success' => false,
                'message' => $validator->errors()->first(),
                'data' => null
            ];
        }

        // Fetch the trailer
        try {
            $trailer = Trailer::findOrFail($request->id);
        } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
            return [
                'success' => false,
                'message' => 'Trailer not found',
                'data' => null
            ];
        }

        // Update the axle tyre configuration
        $trailer->axle_tyre_configuration = $request->axle_tyre_configuration??null;
        $trailer->save();

        return response()->json([
            'success' => true,
            'message' => 'Trailer configuration updated successfully',
            'data' => $trailer
        ], 200);
    }

     // Tyre installation on vehicle via Excle Sheet
    public function tyreTrailerImported(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'file' => 'required|file'
        ]);

        if ($validator->fails()) {
            return [
                'success' => false,
                'message' => $validator->errors()->first(),
                'data' => null
            ];
        }else{
            $file = $request->file('file');
            Excel::queueImport(new TyreTrailerImport, $file);

            $response=[
                'success'=>true,
                'message'=>'Tyres Installed on Trailer Imported Successfully'
            ];

            return response()->json($response);
        }

    }

     //Save Trailer Tyre Configuration
    public function trailerAxleConfiguration(Request $request)
    {
        // Validate the request
        $validator = Validator::make($request->all(), [
            'id' => 'required',
            'axle_configuration' => 'required',
        ]);

        if ($validator->fails()) {
            return [
                'success' => false,
                'message' => $validator->errors()->first(),
                'data' => null
            ];
        }

        // Fetch the trailer
        try {
            $trailer = Trailer::findOrFail($request->id);
        } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
            return [
                'success' => false,
                'message' => 'Trailer not found',
                'data' => null
            ];
        }

        // Update the axle configuration
        $trailer->axle_configuration = $request->axle_configuration??null;
        $trailer->save();

        return response()->json([
            'success' => true,
            'message' => 'Trailer Axle configuration updated successfully',
            'data' => $trailer
        ], 200);
    }

    //Trailer Documents Create/Update
    public function trailerDocumentCreateUpdate(Request $request)
    {
        // Validate the request
        $validator = Validator::make($request->all(), [
            'trailer_id' => 'required',
            'document_name' => 'required',
            'id_number' => 'required',
        ]);

        if ($validator->fails()) {
            return [
                'success' => false,
                'message' => $validator->errors()->first(),
                'data' => null
            ];
        }

        // Save the trailer document record
        $obj['trailer_id'] = $request->input('trailer_id');
        $obj['document_name'] = $request->input('document_name');
        $obj['id_number'] = $request->input('id_number');
        $obj['issue_date'] = $request->input('issue_date');
        $obj['expiry_date'] = $request->input('expiry_date');
        $obj['renewal_date'] = $request->input('renewal_date');
        $obj['attachments'] = $request->input('attachments');
        $obj['remarks'] = $request->input('remarks');

        // Updating the trailer document
        if($request['id']>0){
            $trailer_document = TrailerDocument::find($request['id']);

            if ($trailer_document) {
                $trailer_document->update($obj);
            } else {
                return response()->json([
                    'success' => false,
                    'message' => 'Trailer Document not found',
                    'data' => null
                ], 404);
            }
        }else{
            $trailer_document = TrailerDocument::create($obj);
        }

        $response = [
            'success' => true,
            'message' => $request['id']>0 ? 'Trailer Document updated successfully' : 'Trailer Document created successfully',
            'data' => $trailer_document
        ];

        return response()->json($response, 200);
    }

    // View Trailer Documents list
    public function trailerDocumentsList(Request $request)
    {
         // Validate the request
        $validator = Validator::make($request->all(), [
            'trailer_id' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'message' => $validator->errors()->first(),
                'data' => null
            ], 422);
        }

        $trailer_document = TrailerDocument::where('trailer_id', $request->input('trailer_id'))->get();

        if ($trailer_document) {
            return response()->json([
                'success' => true,
                'message' => 'Trailer Document fetched successfully',
                'data' => $trailer_document
            ], 200);
        } else {
            return response()->json([
                'success' => false,
                'message' => 'No documents found for this trailer',
                'data' => null
            ], 404);
        }
    }

    // View Trailer Document details
    public function trailerDocumentDetails(Request $request)
    {
        // Validate the request
        $validator = Validator::make($request->all(), [
            'id' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'message' => $validator->errors()->first(),
                'data' => null
            ], 422);
        }

        // Fetch trailer document details
        try {
            $trailer_document = TrailerDocument::findOrFail($request->id);

            return response()->json([
                'success' => true,
                'message' => 'Trailer Document details fetched successfully',
                'data' =>$trailer_document
            ], 200);
        } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
            return response()->json([
                'success' => false,
                'message' => 'Trailer Document not found',
                'data' => null
            ], 404);
        }
    }
    
    
    public function store(Request $request)
	{
		// Create a new trailer instance and populate it with request data
		// Validate the request data if needed
		// $this->validate($request, [
		//     // Add validation rules here
		// ]);
    
		$config = [
			[
				"axle" => "Front Axle",
				"no_tyre" => 2,
				"position" => "F",
				"battery_labels" => [
				"Battery1",
				"Battery2"
				],
				"tire_labels_left" => ["FL0"],
				"tire_labels_right" => ["FR0"],
				"rim_labels_left" => ["RL0"],
				"rim_labels_right" => ["RR0"],
			],
			[
				"axle" => "Rear Axle",
				"no_tyre" => 2,
				"position" => "R",
				"stepney_labels" => [
				"Stepney1",
				"Stepney2"
				],
				"tire_labels_left" => ["RL0"],
				"tire_labels_right" => ["RR0"],
				"rim_labels_left" => ["RL0"],
				"rim_labels_right" => ["RR0"],
			],
			];


		// Create a new instance of the Trailer model
		$trailer = new Trailer();

		// Assign values from the request to the model fields
		$trailer->trailer_id = $request->input('trailer_id');
		$trailer->trailer_type = $request->input('trailer_type');
		$trailer->manufacturer = $request->input('manufacturer');
		$trailer->model = $request->input('model');
		$trailer->year = $request->input('year');
		$trailer->vin_no = $request->input('vin_no');
		$trailer->registration_number = $request->input('registration_number');
		$trailer->engine_applicable = $request->input('engine_applicable');
		$trailer->fuel_type = $request->input('fuel_type');
		$trailer->engine_type = $request->input('engine_type');
		$trailer->transmission_type = $request->input('transmission_type');
		$trailer->color = $request->input('color');
		$trailer->mileage = $request->input('mileage');
		$trailer->purchase_date = $request->input('purchase_date');
		$trailer->purchase_price = $request->input('purchase_price');
		$trailer->length = $request->input('length');
		$trailer->width = $request->input('width');
		$trailer->height = $request->input('height');
		$trailer->gvwr = $request->input('gvwr');
		$trailer->tare_weight = $request->input('tare_weight');
		$trailer->payload_capacity = $request->input('payload_capacity');
		$trailer->status = $request->input('status');
		$trailer->remarks = $request->input('remarks');
		$jsonData = json_encode($config);

		$trailer->axle_tyre_configuration = $jsonData;

		// Save the trailer to the database
		$trailer->save();
		
				// if ($request->file('photo')) {
			//     $photo = $request->file('image');
        //     $filename = time() . '.' . $photo->getClientOriginalExtension();
        //     $path = public_path('uploads');
        //     $photo->move($path, $filename);
        //     $trailer->image = $filename;
        // }

        $date = date('Y-m-d');
        $time = date('H:i:s'); 
        $user = Auth::user();
        $UserHistory = new UserHistory();
        $UserHistory->user_id = $user->id;
        $UserHistory->module = 'Trailer';
        $UserHistory->action_type = 'New Trailer Added';
        $UserHistory->item_id = $trailer->id;
        $UserHistory->date = $date;
        $UserHistory->time = $time;
        $UserHistory->save();


    // Redirect to the trailer's details page or the index page
		session()->flash('success', 'Trailer Added Successfully');
		return redirect()->route('trailer.configuration', $trailer->id);
	}    

}
