<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Auth;
use Carbon\Carbon;
use App\Models\Purchase;
use App\Service\PurchaseItemService;

class TransactionController extends Controller
{
    public function submitTransaction(Request $request){
        $user=Auth::user();

        if($request['id']>0){

            try{
            //update transaction
                $transaction = Purchase::findOrFail($request['id']);

                $transaction['invoice_no']=$request['invoice_no'];
                $transaction['supplier_id']=$request['supplier_id'];
                $transaction['invoice_date']=$request['invoice_date'];

                $transaction->update();

            } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
                // Return error message in JSON if ID not found
                return response()->json(['message' => 'Invalid Id to update '], 404);
            }
           
        }else{
            //add new transaction
            $transaction = Purchase::create([
                'invoice_no'=>$request['invoice_no'],
                'supplier_id'=>$request['supplier_id']??0,
                'invoice_date'=>$request['invoice_date'],
                'transaction_date'=>Carbon::today()->format('Y-m-d')
            ]);
            // $transaction['purchase_id']=

            $itemsservice=new PurchaseItemService;
            $itemsservice->additems($transaction,$request);
                
        }

        return response()->json($transaction);
    }

    // Purchases 
    public function getallPurchase(Request $request){

        $transactions=Purchase::where('rolledback',0)
            ->with('supplier');

        if($request['invoice_date']!='' && $request['invoice_date']!=null){
            $transactions=$transactions->whereDate('invoice_date',$request['invoice_date']);
        }
        if($request['invoice_no']!='' && $request['invoice_no']!=null){
            $transactions=$transactions->where('invoice_no',$request['invoice_no']);
        }
        if($request['status']!='' && $request['status']!=null){
            $transactions=$transactions->where('status',$request['status']);
        }
        if($request['supplier_name']!='' && $request['supplier_name']!=null){
            $transactions=$transactions->whereHas('supplier',function($query){
                $query->where('name', 'like', '%' . $request['supplier_name'] . '%');
            });
        }
        
        $transactions=$transactions->get();

        return response()->json($transactions);
    }

    public function getPurchaseDetails(Request $request){
        $transaction=Purchase::where('id',$request['id'])
            ->with('supplier','items','items.elements','items.elements.product:id,name')
            ->first();

        return response()->json($transaction);
    }

    public function changeStatus(Request $request){

        try{

            $transaction=Purchase::findOrFail($request['id']);

        } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
            // Return error message in JSON if ID not found
            return response()->json(['message' => 'Invalid Id to update '], 404);
        }

        if($transaction['status']=='pending'){
            $transaction['status']='approved';
        }else{
            $transaction['status']='pending';
        }
        $transaction->update();

        return response()->json(true);
    }

    public function createreversestocktransaction($entity,$transaction,$inout){                                 
		$model = app("App\Models\\".$entity."Items");
		$subtrans = $model::where('transactionid',$transaction['id'])->where('rolledback',0)->get();
		foreach($subtrans as $row){
			$present = StockTransaction::where('trantype',$transaction['trantype'])
                ->where('transactionid',$transaction['id'])->where('rolledback',0)
                ->where('subtranid',$row['id'])
                ->where('inout',$inout==1?2:1)
                ->first();                                                          
			if($present==null){
				$obj = array();
				$obj['productid']=$row['productid'];
				$obj['storeid']=$transaction['storeid2'];
				$obj['transactiondate']=$transaction['transactiondate'];
				//$obj['unitid']=$row['unitid'];
				$obj['transactionid']=$transaction['id'];
				$obj['subtranid']=$row['id'];
				$obj['inout']=$inout==1?2:1;
				$obj['updatestatus']=0;
				$obj['quantity']=$row['quantity'];
				$obj['trantype']=$transaction['trantype'];
				$obj['fy']=$transaction['fy'];
				//dd($obj);
				$maxsequence = StockTransaction::where('transactiondate',$transaction['transactiondate'])
					->max('dailysequence');
				$obj['dailysequence']=$maxsequence+1;

				$obj = StockTransaction::create($obj);
				

				$dailyService = new DailyService;
				$dailyService->updateNextDayStockStatus($obj);
			}
		}
    }
}
