<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\SaleTransaction;
use App\Models\Quotation;
use App\Models\Invoice;
use App\Models\SaleOrder;
use App\Models\Bill;
use App\Models\Address;
use App\Models\ContactPerson;
use App\Models\BankDetails;
use App\Models\PurchaseOrder;
use App\Models\InsuranceDetail;
use App\Models\Document;
use App\Models\VaccinationDetail;
use App\Models\PaymentDetail;
use App\Service\ProfileService;
use App\Service\ContactPersonService;
use App\Service\BankService;
use App\Service\DocumentsService;
use App\Service\InsuranceDetailService;
use App\Service\VaccinationDetailService;
use App\Service\PaymentDetailsService;
use App\Service\FamilyEmployeeService;
use Auth;
use App\Service\UploadService;
use App\Service\AddressService;
use Log;
use Hash;
use Validator;
use Maatwebsite\Excel\Facades\Excel;
use App\Imports\UserImport;
use App\Service\ActivityService;


class UserController extends Controller

{

    public function createUpdateUser(Request $request){

        $auth=Auth::user();

        $profileservice=new ProfileService;

        $profile=[];

        // Validate Item
        $validator=validator($request->all(),[
            'display_name'=>'required|string',
            'first_name'=>'required',
            // 'customer_type'=>'required'
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];

        } else {

            // ===== Document No Unique Check =====
            if ($request->has('documents') && is_array($request->documents)) {
                foreach ($request->documents as $doc) {
                    if (!empty($doc['document_no'])) {
                        $exists = Document::where('document_no', $doc['document_no'])
                            ->when($request['id'] > 0, function($q) use ($request) {
                                $q->where('user_id', '!=', $request['id']); // exclude current user in update
                            })
                            ->exists();

                        if ($exists) {
                            return response()->json([
                                'success' => false,
                                'message' => "Document number {$doc['document_no']} already exists."
                            ], 200);
                        }
                    }
                }
            }

            // ===== Insurance Policy No Unique Check =====
            if ($request->has('insurance_details') && is_array($request->insurance_details)) {
                foreach ($request->insurance_details as $policy) {
                    if (!empty($policy['policy_no'])) {
                        $exists = InsuranceDetail::where('policy_no', $policy['policy_no'])
                            ->when($request['id'] > 0, function($q) use ($request) {
                                $q->where('user_id', '!=', $request['id']);
                            })
                            ->exists();

                        if ($exists) {
                            return response()->json([
                                'success' => false,
                                'message' => "Insurance policy number {$policy['policy_no']} already exists."
                            ], 200);
                        }
                    }
                }
            }

            // ===== Bank Account No Unique Check =====
            if ($request->has('bank_details') && is_array($request->bank_details)) {
                foreach ($request->bank_details as $bank) {
                    if (!empty($bank['account_no'])) {
                        $exists = BankDetails::where('account_no', $bank['account_no'])
                            ->when($request['id'] > 0, function($q) use ($request) {
                                $q->where('user_id', '!=', $request['id']);
                            })
                            ->exists();

                        if ($exists) {
                            return response()->json([
                                'success' => false,
                                'message' => "Bank account number {$bank['account_no']} already exists."
                            ], 200);
                        }
                    }
                }
            }


            if($request['id']>0){

                try{

                    $user=User::findOrFail($request['id']);

                    if(isset($request['password'])){

                        $user['password']=Hash::make($request['password']);
                        $user['c_password']=$request['password'];
                    } 

                    if($request['is_customer']==1){
                        $user['is_customer']=$request['is_customer'];
                    }

                    if($request['is_user']==1){
                        $user['is_user']=$request['is_user'];
                    }

                    if($request['is_vendor']==1){
                        $user['is_vendor']=$request['is_vendor'];
                    }

                    if($request['is_employee']==1){
                        $user['is_employee']=$request['is_employee'];
                    }

                    if(isset($request['email'])){

                        $user['email']=$request['email'];
                        //$user['vpass']=Hash::make($request['password']);
                    }

                    $user['status']=0;

                    $profile=$profileservice->createupdateProfile($user,$request);

                    $profile->update();


                    // Delete Existing Address
                    Address::where('user_id',$request['id'])->delete();

                    //Deleting Existing Contact Person
                    ContactPerson::where('user_id',$request['id'])->delete();

                    //Deleting Existing Bank Details
                    BankDetails::where('user_id',$request['id'])->delete(); // delete bank details

                    //Deleting Existing Document Details
                    Document::where('user_id',$request['id'])->delete(); // delete bank details

                    //Deleting Existing Vaccination Details
                    VaccinationDetail::where('user_id',$request['id'])->delete(); // delete Vaccination details

                    //Deleting Existing Insurance  Details
                    InsuranceDetail::where('user_id',$request['id'])->delete(); // delete Insurance details

                    //Deleting Existing Payment Detail Details
                    PaymentDetail::where('user_id',$request['id'])->delete(); // delete Payment Detail details


                    // --------------------------------------------------------------------------------------
                    //createing new Address
                    $addressess=new AddressService;
                    $addressess->adreessCreateUpdate($request,$user);

                    //createing new Contact person
                    $contact_person=new ContactPersonService;
                    $contact_person->contactPersonCreateUpdate($request,$user);

                    //createing new Bank Details
                    $bank_service=new BankService;
                    $bank_service->bankServiceCreateUpdate($request,$user); // create bank details

                    //createing new Document Details
                    $doc_service=new DocumentsService;
                    $doc_service->documentCreateUpdate($request,$user); // create Documents details

                    //createing new Vaccination Details
                    $vaccine_service=new VaccinationDetailService;
                    $vaccine_service->vaccinationCreateUpdate($request,$user); // create Vaccination details

                    //createing new Insurance Details
                    $insurance_service=new InsuranceDetailService;
                    $insurance_service->insuranceCreateUpdate($request,$user); // create Insurance details

                    //createing new Payment Details
                    $payment_service=new PaymentDetailsService;
                    $payment_service->paymentDetailCreateUpdate($request,$user); // create Payment details

                    // Creating and Updating Employee and Family Details
                    $employee_service = new FamilyEmployeeService;
                    $employee_service->familyEmployeeCreateUpdate($request, $user);

                } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {

                    // Return error message in JSON if ID not found

                    return response()->json(['message' => 'Invalid Id to update '], 404);

                }

            }else{

                if($request['email']!=null && isset($request['email']) && $request['email'!='']){

                    $checkemail=User::where('email',$request['email'])
                        ->where('organisation_id',$auth['active_organisation'])
                        ->select('id','name','email','organisation_id')
                        ->first();

                    if($checkemail !=null){

                        $response=[
                            'message'=>"Email id already exist",
                            'success'=>false,
                            'vendor'=>$checkemail
                        ];

                        return response()->json($response);
                    }
                }
        
                $obj['first_name']=$request['first_name'];
                $obj['display_name']=$request['display_name'];

                $user=User::create($obj);

                // Setting The Default Organisation

                $user['primary_organisation']=$user['organisation_id'];

                $user['active_organisation']=$user['organisation_id'];

                if($request['app_permission']!=null && isset($request['app_permission'])){
                    $user['app_permission']=$request['app_permission'];
                }else{
                    $user['app_permission']='"{\"accounting\":1,\"hrms\":1,\"pay_roll\":1,\"manufacturing\":1,\"logistics\":1,\"workshop\":1,\"cms\":1,\"container_owner\":1,\"tms\":1,\"legal\":0,\"mice_dsr\":0,\"fleet_tracking\":0}"';
                }

                // Log::info($user);

                if(isset($request['password'])){

                    $user['password']=Hash::make($request['password']);
                    $user['c_password']=$request['password'];

                } 

                if ($request->input('is_customer') == 1) {
                    $user['is_customer'] = 1;
                }

                if ($request->input('is_vendor') == 1) {
                    $user['is_vendor'] = 1;
                }
                if ($request->input('is_employee') == 1) {
                    $user['is_employee'] = 1;
                }
                if ($request->input('is_user') == 1) {
                    $user['is_user'] = 1;
                }

                if(isset($request['email'])){
                    $user['email']=$request['email'];
                }

                $profile=$profileservice->createupdateProfile($user,$request);

                $profile->update();

                $addressess=new AddressService;
                $addressess->adreessCreateUpdate($request,$user);

                //createing new Bank Details
                $bank_service=new BankService;
                $bank_service->bankServiceCreateUpdate($request,$user); // create bank details

                $contact_person=new ContactPersonService;
                $contact_person->contactPersonCreateUpdate($request,$user);
                
                //createing new Document Details
                $doc_service=new DocumentsService;
                $doc_service->documentCreateUpdate($request,$user); // create Documents details

                //createing new Vaccination Details
                $vaccine_service=new VaccinationDetailService;
                $vaccine_service->vaccinationCreateUpdate($request,$user); // create Vaccination details

                //createing new Insurance Details
                $insurance_service=new InsuranceDetailService;
                $insurance_service->insuranceCreateUpdate($request,$user); // create Insurance details

                //createing new Payment Details
                $payment_service=new PaymentDetailsService;
                $payment_service->paymentDetailCreateUpdate($request,$user); // create Payment details

                // Creating and Updating Employee and Family Details
                $employee_service = new FamilyEmployeeService;
                $employee_service->familyEmployeeCreateUpdate($request, $user);


            }   
            $response=[

                'message'=>$request['id']>0? "Record Updated Successfully":"Record Created Successfully",

                'success'=>true

            ];

            return response()->json($response);

        }

    }

    // Getting All the users
    public function fetchuser(Request $request){

        $user=Auth::user();

        if($user!=null){

            $userlist=User::where('is_disabled',0)

                ->with('billing_address','shipping_address','address','address.city','address.state','address.country',
                    'bank_details','contact_person');

                // ->where('organisation_id',$user['active_organisation']);


            $userlist=$this->fetchuserbyquery($userlist,$request);

            $count=$userlist->count();
                                                                                                    
            if(isset($request['sort_by']) && $request['sort_by']!='' && $request['sort_by']!=null){
                
                $sort_order=$request['sort_order']==1?'asc':'desc';

                $userlist = $userlist->orderBy($request['sort_by'],$sort_order);

            }else{
                $userlist = $userlist->orderBy('id','desc');
            }

            $userlist = $userlist->skip($request['noofrec']*($request['currentpage']-1))->take($request['noofrec']??100)

                ->get();

            $response=[
                'user'=>$userlist,
                'count'=>$count,
                'message'=>'Successful',
            ];

        } else {

            $response=[
                'user'=>$userlist,
                'count'=>$count,
                'message'=>'Invalid User'
            ];

        }

        return response()->json($response);

    }

    // Filter Users
    public function fetchuserbyquery($userlist,$request){

        if(isset($request['is_customer']) && $request['is_customer']!=0){

            $userlist=$userlist->where('is_customer',$request['is_customer']);

        }

        if(isset($request['is_vendor']) && $request['is_vendor']!=0){

            $userlist=$userlist->where('is_vendor',$request['is_vendor']);

        }

        if(isset($request['vendor_type']) && $request['vendor_type']!=null){

            $userlist=$userlist->where('vendor_type',$request['vendor_type']);

        }

        if(isset($request['is_user']) && $request['is_user']!=0){

            $userlist=$userlist->where('is_user',$request['is_user']);

        }

        if(isset($request['logistic_provider_id']) && $request['logistic_provider_id']>0){

            $userlist=$userlist->where('logistic_provider_id',$request['logistic_provider_id']);

        }

        if(isset($request['is_employee']) && $request['is_employee']!=0){

            $userlist=$userlist->where('is_employee',$request['is_employee']);

        }
        if(isset($request['is_driver']) && $request['is_driver']!=0){

            $userlist=$userlist->where('is_driver',$request['is_driver']);

        }
        if(isset($request['is_logistics']) && $request['is_logistics']!=0){

            $userlist=$userlist->where('is_logistics',$request['is_logistics']);

        }
        if(isset($request['is_container_owner']) && $request['is_container_owner']!=0){

            $userlist=$userlist->where('is_container_owner',$request['is_container_owner']);

        }

        if(isset($request['employee_user_type']) && $request['employee_user_type']!=0){

            $userlist=$userlist->where('employee_user_type',$request['employee_user_type']);

        }

        if(isset($request['search']) && $request['search']!='') {

            $keyword = "%".$request['search']."%";
        
            $userlist = $userlist->whereRaw(" (first_name like ? or last_name like ? or name like ? or company_name like ? or email like ? or mobile_no like ? or work_phone like ? or customer_type like ? or display_name like ?) ", 
            array($keyword , $keyword ,$keyword , $keyword , $keyword ,$keyword,$keyword,$keyword,$keyword));
        
        }

        if($request['active']!='' && isset($request['active'])){
            $userlist=$userlist->where('active',$request['active']);
        }

        if($request['status']!='' && isset($request['status'])){
            $userlist=$userlist->where('status',$request['status']);
        }

        if($request['customer_type']!='' && isset($request['customer_type'])){

            $userlist=$userlist->where('customer_type',$request['customer_type']);

        }

        if($request['overdue']!='' && isset($request['overdue']) && $request['overdue']!=0){

            $userlist=$userlist->where('balance','<>',0);

        }
        // get custom_date data by transaction_date

        if ($request['custom_date']!='' && isset($request['custom_date'])) {

            $customDate = $request->custom_date;

            $userlist = $userlist->whereDate('created_at', $customDate);

        }

        // get last modified data by updated_at

        if ($request['updated_at']!='' && isset($request['updated_at'])) {

            $userlist=$userlist->orderBy('updated_at');

        }

        // get fromDate toDate data by created_at

        if ($request['fromDate']!='' && isset($request['toDate'])) {

            $fromDate = $request->fromDate;

            $toDate = $request->toDate;

            // 'fromDate' and 'toDate'

            $userlist = $userlist->whereBetween('created_at', [$fromDate, $toDate]);

        }

        return $userlist;

    }

    // Updating a column in User Table
    public function userupdatefield(Request $request){

        $user=Auth::user();

        if($user!=null){

            $profile=User::where('id',$request['userid'])->first();

            $profile[$request['column']]=$request['value'];

            $profile->update();

        }

        return response()->json(true);

    }


    public function uploadimage(Request $request){

        $uploadservice=new UploadService;

        $user=$uploadservice->upload($request);

        return $user;

    }


    public function userscount(Request $request){

        $usercount=User::where('is_disabled',0)->where('isuser',1)->count();

        $membercount=User::where('is_disabled',0)->where('ismember',1)->count();

        $response=[

            'usercount'=>$usercount,

            'membercount'=>$membercount

        ];

        return response()->json($response);

    }


    // Details of the User /Customer /Vendor
    public function getuserdetails(Request $request){

        $response=[];

        $auth=Auth::user();

        // Validate Item
        $validator=validator($request->all(),[

            'user_id'=>'required'

        ]);

        if ($validator->fails()) { 

            return [

                'success' => false, 

                'message' => $validator->errors()->first()

            ];

        } else {

            try{

            $user=User::with('address','address.country:id,name','address.state:id,name','address.city:id,name','contact_person','bank_details',
                    'documents','vaccination_details','insurrance_details','payment_details','account:id,account_name,account_code')
                // ->where('organisation_id',$auth['active_organisation'])

                ->findOrFail($request['user_id']);

            } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {

                // Return error message in JSON if ID not found

                return response()->json(['success'=>false,'message' => 'Invalid Id found'], 404);

            }

            // Log::info($auth);

            // Check if employee_ids is not null and convert it to an array
            if(isset($user->employee_ids) && $user->employee_ids != null && $user->employee_ids != ''){
                $user->employee_ids = str_replace(' ', '', $user->employee_ids); // Remove spaces
                $employeeIds = $user->employee_ids ? array_filter(explode(',', $user->employee_ids)) : [];

                // Remove main user id
                $employeeIds = array_diff($employeeIds, [$user->id]);
            }
           

            // Check if family_ids is not null and convert it to an array
            if(isset($user->family_ids) && $user->family_ids != null && $user->family_ids != ''){
                $user->family_ids = str_replace(' ', '', $user->family_ids);
                $familyIds = $user->family_ids ? array_filter(explode(',', $user->family_ids)) : [];
                // Remove main user id
                $familyIds = array_diff($familyIds, [$user->id]);
            }
            

            // Fetch employee and family member data only if IDs exist
            $employees = !empty($employeeIds) ? User::whereIn('id', $employeeIds)->get() : collect();
            $familyMembers = !empty($familyIds) ? User::whereIn('id', $familyIds)->get() : collect();


            if($user['is_customer']==1){

                $quotation=Quotation::where('customer_id',$request['user_id'])
                    // ->where('organisation_id',$auth['active_organisation'])
                    ->skip($request['noofrec']*($request['currentpage']-1))->take($request['noofrec']??20)
                    ->get();


                $sale_order=SaleOrder::where('customer_id',$request['user_id'])
                    // ->where('organisation_id',$auth['active_organisation'])
                    ->skip($request['noofrec']*($request['currentpage']-1))->take($request['noofrec']??20)
                    ->get();

                $invoice=Invoice::where('customer_id',$request['user_id'])
                    // ->where('organisation_id',$auth['active_organisation'])
                    ->skip($request['noofrec']*($request['currentpage']-1))->take($request['noofrec']??20)
                    ->get();

                $response=[
                    'success'=>true,
                    'message'=>'Customer Details Retrieved Successfully.',
                    'user'=>$user,
                    'quotation'=>$quotation,
                    'sale_order'=>$sale_order,
                    'invoice'=>$invoice,
                    'family_members'=>$familyMembers,
                    'employees'=>$employees
                ];

                 return response()->json($response);

            }

            // Log::info($auth);

            if($user['is_vendor']==1){


                $purchase_order=PurchaseOrder::where('vendor_id',$request['user_id'])

                    ->where('organisation_id',$auth['active_organisation'])

                    ->skip($request['noofrec']*($request['currentpage']-1))->take($request['noofrec']??20)

                    ->get();


                $bill=Bill::where('vendor_id',$request['user_id'])

                    ->where('organisation_id',$auth['active_organisation'])

                    ->skip($request['noofrec']*($request['currentpage']-1))->take($request['noofrec']??20)

                    ->get();



                $response=[
                    'success'=>true,
                    'message'=>'Vendor Details Retrieved Successfully.',
                    'user'=>$user,
                    'purchase_order'=>$purchase_order,
                    'bill'=>$bill,
                    'family_members'=>$familyMembers,
                    'employees'=>$employees
                ];

                return response()->json($response);

            }

            $response=[

                'success'=>true,

                'message'=>'User Details Retrieved Successfully.',

                'user'=>$user

            ];

            return response()->json($response);

        }

    }

    public function userImport(Request $request){

        // Validate Item

        $validator=validator($request->all(),[

            'file' => 'required|file',

            'user_type'=>'required'

        ]);



        if ($validator->fails()) { 

            return [

                'success' => false, 

                'message' => $validator->errors()->first()

            ];

        } else {

            $file = $request->file('file');



            Excel::import(new UserImport, $file);



            if($request['user_type']=='customer'){

                // Creating Activities

                $activity=new ActivityService;

                $activity->activityCreateUpdate('Customer',0,'Imported');



                 // return redirect()->back()->with('success', 'Item imported successfully!');

                $response=[

                    'success'=>true,

                    'message'=>'Customers Excel Imported Successfully'

                ];

            } 



            if($request['user_type']=='vendor'){

                // Creating Activities

                $activity=new ActivityService;

                $activity->activityCreateUpdate('Vendor',0,'Imported');



                 // return redirect()->back()->with('success', 'Item imported successfully!');

                $response=[

                    'success'=>true,

                    'message'=>'Vendors Excel Imported Successfully'

                ];

            }



            return response()->json($response);

        }

    }

    public function status(Request $request){

        $auth=Auth::user();

         // Validate Item
         $validator=validator($request->all(),[
            'user_id'=>'required'
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];
        } else {

            try {

                $user=User::findOrFail($request['user_id']);

                if(isset($request['active'])){
                    $user['active']=$request['active'];
                }

                if(isset($request['status'])){
                    $user['status']=$request['status'];
                }
                // $user['status']=$request['status']??0;

                $user->update();

            } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {

                // Return error message in JSON if ID not found

                return response()->json(['message' => 'Invalid Id found'], 404);

            }

            $response=[

                'success'=>true,

                'message'=>'Status Updated successfully.',

                'user'=>$user

            ];


            return response()->json($response);
        }
    }

    public function delete(Request $request){

        $auth=Auth::user();

         // Validate Item
         $validator=validator($request->all(),[
            'user_id'=>'required'
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];
        } else {

            try {

                $user=User::where('id',$request['user_id'])

                    ->where('organisation_id',$auth['active_organisation'])
                    ->first();

                $user['is_disabled']=1;

                $user->update();

            } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {

                // Return error message in JSON if ID not found

                return response()->json(['message' => 'Invalid Id found'], 404);

            }

            $response=[

                'success'=>true,

                'message'=>'Deleted successfully.'

                // 'user'=>$user

            ];


            return response()->json($response);
        }
    }

    // Update Employee App Permissions like Accounting, HRMS etc.
    public function updateAppPermission(Request $request){
        $user=Auth::user();

        // Validate Item
        $validator=validator($request->all(),[
           'user_id'=>'required',
           'app_permission' => 'required|string'
       ]);

       if ($validator->fails()) { 
           return [
               'success' => false, 
               'message' => $validator->errors()->first()
           ];
       } else {

           try {

                $owner=User::where('id',$user['id'])->first();

                // Only Admin can Update Permission
                if($owner['is_admin']==1){

                    $emp=User::findOrFail($request['user_id']);
                    $emp['app_permission']=$request['app_permission'];
                    $emp->update();

                } else {

                    $response=[
                        'success'=>false,
                        'message'=>'Only Admin can give Permission'
                        // 'user'=>$user
                    ];
        
                    return response()->json($response);
                }  

            } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {

                // Return error message in JSON if ID not found
                return response()->json(['message' => 'Invalid Id found'], 404);
            }

            $response=[
                'success'=>true,
                'message'=>'App Permission Updated successfully.',
                'user'=>$emp
            ];

            return response()->json($response);
        }
    }

    //Delete Family Member from the family_ids column
    public function deleteFamilyMember(Request $request){

        $user=Auth::user();

        // Validate Item
        $validator=validator($request->all(),[
           'user_id'=>'required'
       ]);

       if ($validator->fails()) { 
           return [
               'success' => false, 
               'message' => $validator->errors()->first()
           ];
       } else {

           try {

                $emp = User::findOrFail($request['user_id']);
                  // Convert family_ids string to array

                if(isset($request['family_id']) && $request['family_id']>0){
                    $ids = array_filter(explode(',', $emp->family_ids));

                    // Remove the given family_id
                    $ids = array_filter($ids, function ($id) use ($request) {
                        return $id != $request['family_id'];
                    }); 

                    // Rebuild the string without trailing commas
                    $emp->family_ids = implode(',', $ids);

                    $emp->save();
                }

                if(isset($request['employee_id']) && $request['employee_id']>0){
                    $ids = array_filter(explode(',', $emp->employee_ids));

                    // Remove the given family_id
                    $ids = array_filter($ids, function ($id) use ($request) {
                        return $id != $request['employee_id'];
                    }); 

                    // Rebuild the string without trailing commas
                    $emp->employee_ids = implode(',', $ids);

                    $emp->save();
                }

                

            } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {

                // Return error message in JSON if ID not found
                return response()->json(['success'=>false,'message' => 'Invalid Id found'], 200);
            }

            $response=[
                'success'=>true,
                'message'=>'Family/Employee Member Detached successfully.',
                'user'=>$emp
            ];

            return response()->json($response);
        }
    }

    //get family members
    public function getFamilyMembers(Request $request){

        $user=Auth::user();

        // Validate Item
        $validator=validator($request->all(),[
           'user_id'=>'required'
       ]);

       if ($validator->fails()) { 
           return [
               'success' => false, 
               'message' => $validator->errors()->first()
           ];
       } else {

           try {

                $emp = User::findOrFail($request['user_id']);

                // Convert family_ids string to array
                $ids = array_filter(explode(',', $emp->family_ids));

                $family = User::whereIn('id', $ids)->get()->map(function ($item) {
                    $item->is_family = 1;
                    return $item;
                });

            } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {

                // Return error message in JSON if ID not found
                return response()->json(['success'=>false,'message' => 'Invalid Id found'], 200);
            }

            $response=[
                'success'=>true,
                'message'=>'Family Member fetched successfully.',
                'user'=>$family
            ];

            return response()->json($response);
        }
    }


}