<?php
namespace App\Http\Controllers\Api;
use App\Models\Vendors;
use App\Mail\VendorMail;
use Illuminate\Support\Facades\Mail;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Redirect;
use PDF;
use Excel;

class VendorController extends Controller
{
    public function list(Request $request)
    {
        $vendors= Vendor::all();

        return response()->json($vendors);
    }

    public function details(Request $request)
    {

        $vendor = Vendor::findOrFail($id);

        $response=[
            'vendor'=>$vendor,
            'items'=>$items,
        ];

        return response()->json($response);

    }

    public function send_mail(Request $request)
    {

        $vendor = Vendor::findOrFail($id);

        // Send the email
        Mail::to('recipient@example.com')->send(new VendorMail($vendor));

        $response=[
            'success'=>true,
            'message'=>'Vendor sent Successfully'
        ];

        return response()->json($response);

    }

    public function pdf()
    {
        
        $pdf = PDF::loadView('view');

        // return $pdf->download('sample.pdf');
        return $pdf->stream('Vendor.pdf');
        
    }

    public function export($data)
    {
        return Excel::download(new Vendors($data), 'Vendors.xlsx');
    }
       
    public function store(Request $request)
    {
        // Validate the request data
        $request->validate([
           'vendor_id' => 'required',
            // Add more validation rules as needed
        ]);

        $data=[
            'name','category_id'
        ];
        
        // Assign valiables to objects
        $obj=[];

        foreach ($data as $key => $value) {
            if(isset($request[$value]) && $request[$value]!=null && $request[$value]!=''){
                $obj[$value]=$request[$value];
            }
        }

        // Create the Vendor
        $vendor = Vendor::create($obj);        

        $response=[
            'vendor'=>$vendor,
            'success'=>true,
            'message'=>'Vendor Created Successfully'
        ];

        return response()->json($response);
    }

   
    public function update(Request $request)
    {
        
    }

    public function destroy($id)
    {
        $vendor = Vendor::findOrFail($id);
        $vendor->delete();

        $response=[
            'success'=>true,
            'message'=>'Vendor deleted Successfully'
        ];

        return response()->json($response);
    }

}