<?php

namespace App\Http\Controllers\Api\Warehouse;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Service\ActivityService;
use Auth;
use App\Models\WarehouseRack;
use App\Models\WarehouseBin;

class RackController extends Controller
{
    
    public function createUpdate(Request $request){
        // Validate Name
        $validator=validator($request->all(),[
           'zone_id'=>'required',
           'name'=>'required|string'
       ]);

       if ($validator->fails()) { 
           return [
               'success' => false, 
               'message' => $validator->errors()->first()
           ];
       } else {  
           $obj['zone_id']=$request['zone_id'];
           $obj['warehouse_id']=$request['warehouse_id']??0;
           $obj['name']=$request['name'];
           $obj['description']=$request['description'];
           $obj['capacity']=$request['total_capacity']??0;
           $obj['current_load']=$request['current_load']??0;
           $obj['levels']=$request['number_of_levels']??0;
           $obj['number_of_asile']=$request['number_of_asile']??0;
           $obj['dimension']=$request['dimension'];
           $obj['location_cordinates']=$request['location_cordinates'];

           if($request['id']>0){

               try{
                   
                   $warehouse=WarehouseRack::findOrFail($request['id']);
                   $warehouse->update($obj);

                   // Creating Activities
                   $activity=new ActivityService;
                   $activity->activityCreateUpdate('Warehouse Racks',$warehouse['id'],'Updated');

               } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
                   // Return error message in JSON if ID not found
                   return response()->json(['message' => 'Invalid Id to update '], 404);
               }
           }else{
               $warehouse=WarehouseRack::create($obj);

               // Creating Activities
               $activity=new ActivityService;
               $activity->activityCreateUpdate('Warehouse Racks',$warehouse['id'],'Created');
           }
           
           $response=[
               'success'=>true,
               'data'=>$warehouse,
               'message'=>($request['id'] > 0) ? "Warehouse Racks Updated Successfully" : "Warehouse Racks Created Successfully",
           ];

           return response()->json($response);
       }
   }

   public function list(Request $request)
   {
       $user=Auth::user();

        $warehouse= WarehouseRack::with('warehouse','zone');

        if($request['zone_id']!=0 && isset($request['zone_id'])){
            $warehouse=$warehouse->where('zone_id',$request['zone_id']);
        }

        if($request['warehouse_id']!=0 && isset($request['warehouse_id'])){
            $warehouse=$warehouse->where('warehouse_id',$request['warehouse_id']);
        }

        if($request['search']!='' && isset($request['search']) && $request['search']!=null){
            $warehouse = $warehouse->where(function ($query) use ($request) {

                $query->where('name', 'LIKE', '%' . $request['search'] . '%');
            });
        }

        if($request['is_active']!='' && isset($request['is_active']) && $request['is_active']!=null){
            $warehouse = $warehouse->where('is_active',$request['is_active']);
        }

        if($request['warehouse_type']!='' && isset($request['warehouse_type']) && $request['warehouse_type']!=null){
            $warehouse = $warehouse->where('warehouse_type',$request['warehouse_type']);
        }

        if($request['department']!='' && isset($request['department']) && $request['department']!=null){
            // Decode the JSON string into an array
            $decodedValues = json_decode($request['department'], true);
            $warehouse = $warehouse->whereHas('warehouse',function($query) use ($decodedValues){
                $query->whereJsonContains('department',$decodedValues);
            });
        }
        

        $count=$warehouse->count();

        if(isset($request['sort_by']) && $request['sort_by']!='' && $request['sort_by']!=null){
                
            $sort_order=$request['sort_order']==1?'asc':'desc';

            $warehouse = $warehouse->orderby($request['sort_by'],$sort_order);

        }else{
            $warehouse = $warehouse->orderby('id','desc');
        }

        $warehouse=$warehouse->skip($request['noofrec']*($request['currentpage']-1))->take($request['noofrec']??50)
        // ->orderBy('id','desc')
        ->get();

        $response=[
            'success'=>true,
            'count'=>$count,
            'data'=>$warehouse,
            'message'=>'Warehouse Racks List',
        ];

        return response()->json($response);

    }
   

    public function details(Request $request){

        $user=Auth::user();
        // Validate Name
        $validator=validator($request->all(),[
           'rack_id'=>'required'
       ]);

       if ($validator->fails()) { 
           return [
               'success' => false, 
               'message' => $validator->errors()->first()
           ];
       } else {  
            $warehouse= WarehouseRack::with('warehouse','zone')
                ->where('id',$request['rack_id'])->first();

            $bins=WarehouseBin::where('rack_id',$request['rack_id'])
                ->where('is_disabled',0)
                ->count();

            $response=[
                'success'=>true,
                'data'=>$warehouse,
                'message'=>'Warehouse Racks Details',
                'no_of_bins'=>$bins
            ];

            return response()->json($response);
       }

    }

    // Update status Active and In Active
    public function status(Request $request){

        // Validate Item

        $validator=validator($request->all(),[

           'rack_id'=>'required|integer',

           'is_active'=>'required|integer'

       ]);

       if ($validator->fails()) { 

           return [

               'success' => false, 

               'message' => $validator->errors()->first(),

           ];

       } else {

           try{

               $warehouse =  WarehouseRack::where('id',$request->input('rack_id'))->first();

               $warehouse['is_active']=$request['is_active'];

               $warehouse->update();

               $response=[

                   'success'=>true,

                   'message'=>'Status Updated successfully.',

                   'data'=>$warehouse

               ];

           } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {

               // Return error message in JSON if ID not found

               return response()->json(['message' => 'Invalid Id found'], 404);

           }

           return response()->json($response);

       }

   }
}
