<?php

namespace App\Http\Controllers\Api\Workshop;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Workshop\WorkshopInspection;
use App\Models\Workshop\WorkshopInspectionChecklist;
use App\Models\Workshop\WorkshopInspectionPart;
use App\Models\Workshop\WorkshopVisualInspection;
use Carbon\Carbon;
use App\Service\ActivityService;
use App\Models\Workshop\WorkshopInspectionTemplate;
use App\Models\Workshop\WorkshopTemplateRow;
use App\Models\Workshop\JobCard;
use Illuminate\Support\Facades\Validator;

class WorkshopInspectionController extends Controller
{
    //Create Inspection and Diagnostic
    public function inspectionCreateUpdate(Request $request)
    {
        $validator = validator($request->all(), [
            'job_card_id' => 'required',
            'template_id' => 'required',
        ]);

        if ($validator->fails()) {
            return [
                'success' => false,
                'message' => $validator->errors()->first(),
            ];
        } else {
            // Logic to create or update the inspection

            // check if the inspection already exists
            $inspection = WorkshopInspection::where('job_card_id', $request['job_card_id'])
                // ->where('template_id', $request['template_id'])
                ->first();
            if ($inspection) {
                // If inspection exists, update it
                return [
                    'success' => false,
                    'message' => 'Inspection already exists for this job card.',
                ];
            } else {
                // If inspection does not exist, create a new one
                $obj = [];
            }

            $obj['job_card_id'] = $request['job_card_id'];

            $obj['date_time'] = $request['date_time'] ?? Carbon::now()->toDateTimeString();
            $obj['inspected_by'] = $request['inspected_by'] ?? 0;
            $obj['inspection_signature'] = $request['inspection_signature'] ?? null;
            $obj['driver_signature'] = $request['driver_signature'] ?? null;

            $obj['template_id'] = $request['template_id'];

            $inspection=WorkshopInspection::create($obj);

            // Creating Visual Inspection
            if ($request['visual_inspection'] && count($request['visual_inspection']) > 0) {
                foreach ($request['visual_inspection'] as $key => $visual) {
                    $visual_inspect['product_id'] = $visual['product_id']??0;
                    $visual_inspect['price'] = $visual['price']??0.0;
                    $visual_inspect['labour_hour'] = $visual['labour_hour']??0;
                    $visual_inspect['labour_costs'] = $visual['labour_costs']??0.0;
                    $visual_inspect['visual_inspection'] = $visual['visual_inspection']??null;
                    $visual_inspect['attachments'] = $visual['attachments']??null;
                    $visual_inspect['job_card_id'] = $request['job_card_id']??0;
                    $visual_inspect['inspection_id'] = $inspection->id;

                    $visual_inspection = WorkshopVisualInspection::create($visual_inspect);
                }
            }

            //Creating or updating the inspection Checklist
            if($request['inspection_checklist'] && count($request['inspection_checklist']) > 0) {

                foreach ($request['inspection_checklist'] as $key => $value) {
                    $check['job_card_id'] = $request['job_card_id'];
                    $check['inspection_id'] = $inspection->id;
                    $check['template_group_id'] = $value['template_group_id'] ?? 0;
                    $check['template_row_id'] = $value['template_row_id'] ?? 0;
                    $check['check_type'] = $value['check_type'] ?? 0;
                    $check['description'] = $value['description'] ?? null;
                    $check['comments'] = $value['comments'] ?? null;
                    $check['estimated_hrs'] = $value['estimated_hrs'] ?? 0;
                    $check['estimated_cost'] = $value['estimated_cost'] ?? 0;
                    $check['product_id'] = $value['product_id'] ?? 0;
                    $check['product_price'] = $value['product_price'] ?? 0;
                    $check['product_cost'] = $value['product_cost'] ?? 0;
                    $check['urgency'] = $value['urgency'] ?? 0;
                    $check['attachments'] = $value['attachments'] ?? null;

                    $inspection_checklist=WorkshopInspectionChecklist::create($check);

                }
            }

            // Create Additional Parts If Any
            if($request['inspection_parts'] && count($request['inspection_parts']) > 0) {

                foreach ($request['inspection_parts'] as $part) {
                    $part_data['job_card_id'] = $request['job_card_id'];
                    $part_data['inspection_id'] = $inspection->id;
                    $part_data['product_id'] = $part['product_id'] ?? null;
                    $part_data['quantity'] = $part['quantity'] ?? 1;
                    $part_data['description'] = $part['description'] ?? null;
                    $part_data['cost'] = $part['cost'] ?? 0;
                    $part_data['price'] = $part['price'] ?? 0;

                    WorkshopInspectionPart::create($part_data);
                }
            }

            return [
                'success' => true,
                'message' => 'Inspection Created successfully.',
                'inspection' => $inspection
            ];
        }
    }

    // Inspection List
    public function inspectionList(Request $request)
    {
        $inspection = WorkshopInspection::with(['checklist','job_card'])
            // ->where('job_card_id', $request['job_card_id'])
            ->orderBy('id', 'desc');

        if (isset($request['status']) && $request['status'] != '') {
            $inspection = $inspection->where('status', $request['status']);
        }

        if ($request['search'] != null && $request['search'] != '') {
            $inspection = $inspection->where(function ($query) use ($request) {
                $query->where('date_time', 'LIKE', '%' . $request['search'] . '%')
                    ->orWhere('inspected_by', 'LIKE', '%' . $request['search'] . '%')
                    ->orWhereHas('job_card', function ($q) use ($request) {
                        $q->where('job_card_no', 'LIKE', '%' . $request['search'] . '%')
                            ->orWhere('vehicle_no', 'LIKE', '%' . $request['search'] . '%');
                    });
            });
        }

        $count = $inspection->count();

        $inspection = $inspection->skip($request['noofrec'] * ($request['currentpage'] - 1))
            ->take($request['noofrec'] ?? 100)
            ->get();

        return [
            'success' => true,
            'message' => 'Inspection list retrieved successfully.',
            'data' => $inspection,
            'count' => $count
        ];
    }
    // Inspection Details
    public function inspectionDetails(Request $request)
    {
        $validator = validator($request->all(), [
            'inspection_id' => 'required',
        ]);
        if ($validator->fails()) {
            return [
                'success' => false,
                'message' => $validator->errors()->first(),
            ];
        }
        
        $inspection = WorkshopInspection::with(['checklist','visual_inspection','job_card'])
            ->where('id', $request['inspection_id'])
            ->first();

        if (!$inspection) {
            return [
                'success' => false,
                'message' => 'Inspection not found.',
            ];
        }

        return [
            'success' => true,
            'message' => 'Inspection details retrieved successfully.',
            'data' => $inspection
        ];
    }
    // Delete Inspection
    public function inspectionDelete(Request $request)
    {
        $validator = validator($request->all(), [
            'inspection_id' => 'required',
        ]);

        if ($validator->fails()) {
            return [
                'success' => false,
                'message' => $validator->errors()->first(),
            ];
        } else {
            $inspection = WorkshopInspection::findOrFail($request['inspection_id']);
            $inspection->delete();

            // Optionally delete related checklist and parts
            WorkshopInspectionChecklist::where('inspection_id', $request['inspection_id'])->delete();
            // WorkshopInspectionPart::where('inspection_id', $request['inspection_id'])->delete();

            return [
                'success' => true,
                'message' => 'Inspection deleted successfully.',
            ];
        }
    }
    // Update Inspection Status
    public function inspectionStatusUpdate(Request $request)
    {
        $validator = validator($request->all(), [
            'inspection_id' => 'required',
            'status' => 'required',
        ]);

        if ($validator->fails()) {
            return [
                'success' => false,
                'message' => $validator->errors()->first(),
            ];
        } else {
            $inspection = WorkshopInspection::findOrFail($request['inspection_id']);
            $inspection->status = $request['status'];
            $inspection->save();

            return [
                'success' => true,
                'message' => 'Inspection status updated successfully.',
                'data' => $inspection
            ];
        }
    }
    // Update Inspection Checklist Status
    public function inspectionChecklistStatusUpdate(Request $request)
    {
        $validator = validator($request->all(), [
            'checklist_id' => 'required',
            'status' => 'required',
        ]);

        if ($validator->fails()) {
            return [
                'success' => false,
                'message' => $validator->errors()->first(),
            ];
        } else {
            $checklist = WorkshopInspectionChecklist::findOrFail($request['checklist_id']);
            $checklist->status = $request['status'];
            $checklist->save();

            return [
                'success' => true,
                'message' => 'Inspection checklist status updated successfully.',
                'data' => $checklist
            ];
        }
    }
    // Delete Inspection Checklist
    public function inspectionChecklistDelete(Request $request)
    {
        $validator = validator($request->all(), [
            'checklist_id' => 'required',
        ]);

        if ($validator->fails()) {
            return [
                'success' => false,
                'message' => $validator->errors()->first(),
            ];
        } else {
            $checklist = WorkshopInspectionChecklist::findOrFail($request['checklist_id']);
            $checklist->delete();

            return [
                'success' => true,
                'message' => 'Inspection checklist deleted successfully.',
            ];
        }
    }
    // Delete Inspection Part
    public function inspectionPartDelete(Request $request)
    {
        $validator = validator($request->all(), [
            'part_id' => 'required',
        ]);

        if ($validator->fails()) {
            return [
                'success' => false,
                'message' => $validator->errors()->first(),
            ];
        } else {
            $part = WorkshopInspectionPart::findOrFail($request['part_id']);
            $part->delete();

            return [
                'success' => true,
                'message' => 'Inspection part deleted successfully.',
            ];
        }
    }
}
