<?php

namespace App\Http\Controllers\Api\Workshop;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Workshop\WorkshopInspectionTemplate;
use App\Models\Workshop\WorkshopTemplateRow;
use App\Models\Workshop\JobCard;
use App\Service\ActivityService;

class WorkshopInspectionTemplateController extends Controller
{
     // Inspection Template Create Update
    public function inspectionTemplateCreateUpdate(Request $request){

         $validator=validator($request->all(),[
            'template_name'=>'required'
            // 'paid_by'=>'required'
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];

        } else {

            $obj['template_name']=$request['template_name'];   // New Customer 2. Existing Customer 3. Owned Vehicle
            $obj['description']=$request['description']??null;
            $obj['comments']=$request['comments']??null;

            if($request['id']>0){
                try {
                    
                    $template=WorkshopInspectionTemplate::findOrFail($request['id']);
                    $template->update($obj);

                    // Creating Activities
                    $activity=new ActivityService;
                    $activity->activityCreateUpdate('Template',$template['id'],'Updated');

                } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
                    // Return error message in JSON if ID not found
                    return response()->json(['message' => 'Invalid Id to update '], 404);
                }
    
            }else{

                $template=WorkshopInspectionTemplate::create($obj);

                if($request['template_rows'] && count($request['template_rows'])>0){

                    foreach($request['template_rows'] as $row){

                        $row_data['template_id']=$template['id']; 
                        $row_data['group_id']=$row['group_id'];   // Workshop Groups from the masters
                        $row_data['group_name']=$row['group_name'];
                        $row_data['order_no']=$row['order_no'];
                        $row_data['input_type']=$row['input_type'];
                        $row_data['repair_time_yellow']=$row['repair_time_yellow']??0;
                        $row_data['repair_time_red']=$row['repair_time_red']??0;
                        $row_data['product_id']=$row['product_id']??0;
                        $row_data['description']=$row['description'];
                        $row_data['comments']=$row['comments'];
                        $row_data['status']=1;

                        // Creating Template Rows
                        WorkshopTemplateRow::create($row_data);
                    }
                }

                 // Creating Activities
                $activity=new ActivityService;
                $activity->activityCreateUpdate('Inspection Template',$template['id'],'Created');
            }

            $response=[
                'success'=>true,
                'message'=>"Inspection Template Created Successfully",
                'data'=>$template
            ];
            return response()->json($response);
            
        }   
    }

    // Template List
    public function templateList(Request $request){

        $template=WorkshopInspectionTemplate::where('rolledback',0)
            ->with('template_rows');

        if(isset($request['status']) && $request['status']!=''){
            $template=$template->where('status',$request['status']);
        }

        if($request['search']!=null && $request['search']!=''){

            $template = $template->where(function ($query) use ($request) {

                $query->where('template_name', 'LIKE', '%' . $request['search'] . '%');
                $query->orWhere('description', 'LIKE', '%' . $request['search'] . '%');
            });
        }

        $count=$template->count();

        $template =$template->orderBy('id','desc')
            ->skip($request['noofrec']*($request['currentpage']-1))->take($request['noofrec']??100)
            ->get();

        $response=[
            'success'=>true,
            'total'=>$count,
            'data'=>$template
        ];

        return response()->json($response);

    }

    // Inspection Template Details
    public function inspectionTemplateDetails(Request $request){

        $validator=validator($request->all(),[
            'id'=>'required',
        ]);

        if ($validator->fails()) { 

            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];

        } else {
            $template=WorkshopInspectionTemplate::where('id',$request['id'])
                ->with('template_rows')
                ->first();

            if($template){
                $response=[
                    'success'=>true,
                    'data'=>$template
                ];
            }else{
                $response=[
                    'success'=>false,
                    'message'=>"No Template Found"
                ];
            }
            return response()->json($response);
        }
    }

    // Update Inspection Template Status
    public function inspectionTemplateStatus(Request $request){

          $validator=validator($request->all(),[
            'id'=>'required',
            'status'=>'required'
        ]);

        if ($validator->fails()) { 

            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];

        } else {
            $template=WorkshopInspectionTemplate::findOrFail($request['id']);

            $template['status']=$request['status'];

            $template->update();

            $response=[
                'success'=>true,
                'message'=>"Inspection Template Status Updated Successfully",
                'data'=>$template
            ];
        }
    }

    // Delete Inspection Template
    public function inspectionTemplateDelete(Request $request){

        $validator=validator($request->all(),[
            'id'=>'required',
        ]);

        if ($validator->fails()) { 

            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];

        } else {
            $template=WorkshopInspectionTemplate::findOrFail($request['id']);

           //Deleting Template Rows
            $row=WorkshopTemplateRow::where('template_id',$template['id'])->update(
                ['rolledback'=>1]
            );

            // Soft delete the template
            $template['rolledback']=1; // Mark as rolled back
            $template->update();

            // Creating Activities
            $activity=new ActivityService;
            $activity->activityCreateUpdate('Inspection Template',$template['id'],'Deleted');

            return response()->json(['success' => true, 'message' => 'Inspection Template Deleted Successfully']);
        }
    }

    // workshop inspection template rows Delete
    public function inspectionTemplateRowDelete(Request $request){
        $validator=validator($request->all(),[
            'id'=>'required',
        ]);
        if ($validator->fails()) {
            return [
                'success' => false,
                'message' => $validator->errors()->first()
            ];
        } else {
            $row=WorkshopTemplateRow::findOrFail($request['id']);
            $row['rolledback']=1; // Mark as rolled back
            $row->update();
            
            // Creating Activities
            $activity=new ActivityService;
            $activity->activityCreateUpdate('Template Row',$row['id'],'Deleted');

            return response()->json(['success' => true, 'message' => 'Template Row Deleted Successfully']);
        }
    }
}
