<?php

namespace App\Http\Controllers\Api\cms;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Carbon\Carbon;
use Illuminate\Support\Facades\Validator;
use App\Models\cms\CmsPurchaseOrder;
use App\Models\cms\ContainerDetail;

class CmsPurchaseOrderController extends Controller {
    
    public function purchaseOrderCmsList(Request $request){

        $purchase_order=CmsPurchaseOrder::with('vendor');

        if($request['expected_date']!=null){
            $purchase_order=$purchase_order->where('expected_date',$request['expected_date']);
        }

        $count=$purchase_order->count();

        if(isset($request['sort_by']) && $request['sort_by']!='' && $request['sort_by']!=null){
                
            $sort_order=$request['sort_order']==1?'asc':'desc';

            $purchase_order = $purchase_order->orderby($request['sort_by'],$sort_order);

        }else{
            $purchase_order = $purchase_order->orderby('id','desc');
        }
        
        $purchase_order=$purchase_order->skip($request['noofrec']*($request['currentpage']-1))->take($request['noofrec']??50)
                // ->orderBy('id','desc')
                ->get();

        $response=[
            'success'=>true,
            'count'=>$count,
            'data'=>$purchase_order,
            'message'=>'All CMS Purchase Order Listed Successfully'
        ];
        
        return response()->json($response);
    }

    public function purchaseOrderCmsDetails(Request $request){
        $validator=validator($request->all(),[
            'id'=>'required'
        ]);

        //Inout 1 = payment rec , 2= payment made

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];
        } else {


            $purchase_order=CmsPurchaseOrder::where('id',$request['id'])
                ->with('items','port_details','port_details.country','port_details.state',
                'port_details.city','vendor')
                ->first();

                 // Get container details with relationships
            $container_details = ContainerDetail::whereIn('id', explode(',', $purchase_order->container_detail_ids))
                ->with([
                    'container_owner',
                    'container_types',
                    'logisticProvider',
                    'vehicleMaster',
                ])
                ->get();

            $purchase_order['container_details']=$container_details;

            $response = [

                'success' => true,

                'message' => 'Cms Purchae Order Transactions Details',

                'data' => $purchase_order,

            ];

            return response()->json($response);
        }
    }
}