<?php

namespace App\Http\Controllers\Api\cms;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\cms\Order;
use App\Models\cms\ContainerDetail;
use App\Models\Trip\TripContainer;
use Illuminate\Support\Facades\Session;
use Auth;

class ContainerOwnerController extends Controller
{

    // Get all containers in Inventory
    public function getallContainers(Request $request){

        $auth = Auth::user();
        if($auth['is_container_owner'] == 1){
            $containers = ContainerDetail::where('container_owner_id', $auth['id'])
                ->with('container_types')
                ->where('status','pending');    
            
        }else{
            $containers = ContainerDetail::where('container_owner_id', $request['container_owner_id'])
                ->with('container_types')
                ->where('status','pending');
        }

        if(isset($request['container_id']) && $request['container_id'] != null){
            $containers = $containers->where('container_id', 'like', '%'.$request['container_id'].'%');
        }

        if($request['search']!=null && $request['search']!=''){

            $containers = $containers->where(function ($query) use ($request) {

                $query->where('container_id', 'LIKE', '%' . $request['search'] . '%');

               
            });
        }

        $count = $containers->count();

        if(isset($request['sort_by']) && $request['sort_by']!='' && $request['sort_by']!=null){
            
            $sort_order=$request['sort_order']==1?'asc':'desc';

            $containers = $containers->orderby($request['sort_by'],$sort_order);

        }else{
            $containers = $containers->orderby('id','desc');
        }

        $containers = $containers->skip($request['noofrec']*($request['currentpage']-1))->take($request['noofrec']??100)
            ->get();

        $response=[
            'success'=>true,
            'total'=>$count,
            'containers' => $containers,
            'message' => 'Containers retrieved successfully',
            'status' => 200
        ];
        return response()->json($response);
        
    }

    // get all trip containers
    public function getTripContainers(Request $request){

        $auth = Auth::user();

        if($auth['is_container_owner'] == 1){
            $containers = TripContainer::where('container_owner_id', $auth['id'])
                ->with('trip_booking','container_types');
            
        }else{
            $containers = TripContainer::where('container_owner_id', $request['container_owner_id'])
                ->with('trip_booking','container_types');
        }

        if(isset($request['container_id']) && $request['container_id'] != null){
            $containers = $containers->where('container_id', 'like', '%'.$request['container_id'].'%');
        }

        if($request['search']!=null && $request['search']!=''){

            $containers = $containers->where(function ($query) use ($request) {

                $query->where('container_id', 'LIKE', '%' . $request['search'] . '%');

               
            });
        }

        $count = $containers->count();

        if(isset($request['sort_by']) && $request['sort_by']!='' && $request['sort_by']!=null){
            
            $sort_order=$request['sort_order']==1?'asc':'desc';

            $containers = $containers->orderby($request['sort_by'],$sort_order);

        }else{
            $containers = $containers->orderby('id','desc');
        }

        $containers = $containers->skip($request['noofrec']*($request['currentpage']-1))->take($request['noofrec']??100)
            ->get();

        $response=[
            'containers' => $containers,
            'success'=>true,
            'total'=>$count,
            'message' => 'Containers retrieved successfully',
            'status' => 200
        ];
        return response()->json($response);
    }

}
