<?php

namespace App\Http\Controllers\Api\cms;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\cms\ContainerStatus;
use App\Models\cms\LoadOnTruck;
use App\Models\cms\ContainerDetail;
use App\Models\cms\ContainerActivity;
use App\Models\cms\Supplier;
use App\Models\cms\ContainerOwner;
use App\Models\cms\PreArrivalDeparture;
use App\Models\cms\LogisticProvider;
use App\Models\Tms\Vehicle;
use App\Models\cms\Masters\Port;
use App\Models\cms\Masters\VehicleType;
use App\Service\cms\SupplierService;
use App\Service\cms\ContainerDetailsService;
use App\Service\cms\ContainerActivityService;
use App\Models\cms\Masters\ContainerType;
use Illuminate\Support\Facades\Session;
use Carbon\Carbon;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Redirect;

class ContainerStatusController extends Controller
{
    //

    public function index(Request $request)
    {
        try {
            // Base query for container statuses where 'is_close' is 0
            $container_status = ContainerStatus::where('is_close', 0)
                ->with('entrybyid:id,name', 'container_owner:id,company_name', 'port:id,name');

            // Filtering based on 'container_owner_id'
            if (!empty($request->container_owner_id)) {
                $container_status->where('container_owner_id', $request->container_owner_id);
            }

            // Filtering based on 'port_id'
            if (!empty($request->port_id)) {
                $container_status->where('port_id', $request->port_id);
            }

            // Filtering based on 'date'
            if (!empty($request->date)) {
                $container_status->whereDate('created_at', $request->date);
            }

            // Searching based on 'search' keyword (container_id, company_name, or port name)
            if (!empty($request->search)) {
                $search = $request->search;
                $container_status->where(function ($query) use ($search) {
                    $query->where('container_id', 'LIKE', "%{$search}%")
                        ->orWhereHas('container_owner', function ($q) use ($search) {
                            $q->where('company_name', 'LIKE', "%{$search}%");
                        })
                        ->orWhereHas('port', function ($q) use ($search) {
                            $q->where('name', 'LIKE', "%{$search}%");
                        });
                });
            }

            // Count total records for pagination
            $count = $container_status->count();

            // Pagination parameters (with defaults)
            $noOfRec = $request->noofrec ?? 100;
            $currentPage = $request->currentpage ?? 1;

            // Sorting functionality
            if (!empty($request->sort_by)) {
                $sortOrder = ($request->sort_order == 1) ? 'asc' : 'desc';
                $container_status->orderBy($request->sort_by, $sortOrder);
            } else {
                $container_status->orderBy('id', 'desc');
            }

            // Apply pagination
            $container_status = $container_status->skip($noOfRec * ($currentPage - 1))
                ->take($noOfRec)
                ->get();

            // Fetch active ports
            $ports = Port::where('status', 0)->get();

            // Response structure
            return response()->json([
                'success' => true,
                'total' => $count,
                'data' => [
                    'container_status' => $container_status,
                    'ports' => $ports,
                ],
            ], 200);
        } catch (\Exception $e) {
            // Handle unexpected errors
            return response()->json([
                'success' => false,
                'message' => 'Error occurred while processing the request',
                'error' => $e->getMessage(),
            ], 500);
        }
    }


    public function index_close(Request $request)
    {
        try {
            // Base query for closed container statuses (is_close = 1)
            $container_status = ContainerStatus::where('is_close', 1)
                ->with('entrybyid:id,name', 'container_owner:id,company_name', 'port:id,name');

            // Filtering based on 'container_owner_id'
            if (!empty($request->container_owner_id)) {
                $container_status->where('container_owner_id', $request->container_owner_id);
            }

            // Filtering based on 'port_id'
            if (!empty($request->port_id)) {
                $container_status->where('port_id', $request->port_id);
            }

            // Filtering based on 'date'
            if (!empty($request->date)) {
                $container_status->whereDate('created_at', $request->date);
            }

            // Searching based on 'search' keyword (container_id, company_name, or port name)
            if (!empty($request->search)) {
                $search = $request->search;
                $container_status->where(function ($query) use ($search) {
                    $query->where('container_id', 'LIKE', "%{$search}%")
                        ->orWhereHas('container_owner', function ($q) use ($search) {
                            $q->where('company_name', 'LIKE', "%{$search}%");
                        })
                        ->orWhereHas('port', function ($q) use ($search) {
                            $q->where('name', 'LIKE', "%{$search}%");
                        });
                });
            }

            // Count total records for pagination
            $count = $container_status->count();

            // Pagination parameters (with defaults)
            $noOfRec = $request->noofrec ?? 100;
            $currentPage = $request->currentpage ?? 1;

            // Sorting functionality
            if (!empty($request->sort_by)) {
                $sortOrder = ($request->sort_order == 1) ? 'asc' : 'desc';
                $container_status->orderBy($request->sort_by, $sortOrder);
            } else {
                $container_status->orderBy('id', 'desc');
            }

            // Apply pagination
            $container_status = $container_status->skip($noOfRec * ($currentPage - 1))
                ->take($noOfRec)
                ->get();

            // Fetch active ports
            $ports = Port::where('status', 0)->get();

            // Response structure (for API response)
            return response()->json([
                'success' => true,
                'total' => $count,
                'data' => [
                    'container_status' => $container_status,
                    'ports' => $ports,
                ],
            ], 200);
        } catch (\Exception $e) {
            // Handle unexpected errors
            return response()->json([
                'success' => false,
                'message' => 'Error occurred while processing the request',
                'error' => $e->getMessage(),
            ], 500);
        }
    }


    public function create()
    {
        $containertype = ContainerType::where('status', 0)->get();

        $ports = Port::where('status', 0)->get();

        $containerOwners = ContainerOwner::where('status', 0)->get();

        return view('container-status.create', compact('containertype', 'ports', 'containerOwners'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'container_no' => 'required'
        ]);

        $today = new Carbon();

        // if(isset($request['service_offered']))
        // $request['service_offered']=$request['service_offered'];

        $container_status = ContainerStatus::create($request->all());

        $container_status['date'] = $today->format('Y-m-d');
        $container_status['status'] = 'Initial Stage';
        $container_status->update();

        // Save Supplier Details
        $supplierService = new SupplierService;
        $supplierService->addsuppliers($request, $container_status);

        // set session
        Session::flash('success', 'Container created successfully');

        return redirect()->route('tracking.index')->with('success', 'Container Added Successfully.');
    }

    public function update(Request $request)
    {
        $request->validate([
            'container_no' => 'required'
        ]);

        $today = new Carbon();

        // if(isset($request['service_offered']))
        // $request['service_offered']=$request['service_offered'];

        $container_status = ContainerStatus::where('id', $request['container_status_id'])->first();

        $container_status['container_no'] = $request['container_no'];
        $container_status['container_type'] = $request['container_type'];
        $container_status['internal_dimension'] = $request['internal_dimension'];
        $container_status['door_opening'] = $request['door_opening'];
        $container_status['cubic_capacity'] = $request['cubic_capacity'];
        $container_status['cargo_weight'] = $request['cargo_weight'];
        $container_status['container_condition'] = $request['container_condition'];
        $container_status['bill_no'] = $request['bill_no'];
        $container_status['seal_no'] = $request['seal_no'];
        $container_status['container_owner_id'] = $request['container_owner_id'];
        $container_status['port_id'] = $request['port_id'];
        $container_status['booking_no'] = $request['booking_no'];
        $container_status['expected_date'] = $request['expected_date'];
        // $container_status['status']='Initial Stage';
        $container_status->update();

        // Save Supplier Details
        $supplierService = new SupplierService;
        $supplierService->addsuppliers($request, $container_status);

        // set session
        Session::flash('success', 'Container created successfully');

        return redirect()->route('tracking.index')->with('success', 'Container Added Successfully.');
    }

    public function edit($id)
    {

        // dd($id);
        $container = ContainerStatus::where('id', $id)
            ->with('port')->first();


        $supplier = Supplier::where('container_status_id', $id)->first();

        $containertype = ContainerType::where('status', 0)->get();

        $ports = Port::where('status', 0)->get();

        $containerOwners = ContainerOwner::where('status', 0)->get();

        return view('container-status.edit', compact('container', 'containertype', 'supplier', 'ports', 'containerOwners'));
    }

    public function details($id)
    {

        // dd($id);
        $container = ContainerStatus::where('id', $id)
            ->with('port')->first();

        // Check if the container exists
        if ($container) {
            // Retrieve container activities where the JSON field 'container_nos' contains the $id value
            // Eager load the 'load_on_truck' relationship
            $container_activities = ContainerActivity::whereJsonContains('container_nos', $id)
                ->with('load_on_truck')
                ->get();
        } else {
            // Handle the case where the container is not found
            $container_activities = collect(); // Empty collection
        }

        $load_on_truck_id = ContainerActivity::whereJsonContains('container_nos', $id)
            ->where('load_on_truck_id', '>', 0)
            ->pluck('load_on_truck_id');

        $load_on_truck = [];
        if (!$load_on_truck_id->isEmpty()) {

            $load_on_truck = LoadOnTruck::where('id', $load_on_truck_id[0])
                ->with('entrybyid:id,name', 'port:id,name', 'logistic_provider', 'vehicle_types', 'vehicle:id,vehicle_id')
                ->first();
        }

        $supplier = Supplier::where('container_status_id', $id)->first();

        $containertype = ContainerType::where('status', 0)->get();

        $ports = Port::where('status', 0)->get();

        $containerOwners = ContainerOwner::where('status', 0)->get();

        return view('container-status.details', compact('container', 'load_on_truck', 'container_activities', 'containertype', 'supplier', 'ports', 'containerOwners', 'load_on_truck_id'));
    }


    public function truckDetails($id)
    {

        $load_on_truck = LoadOnTruck::where('id', $id)
            ->with('entrybyid:id,name', 'port:id,name', 'logistic_provider', 'vehicle_types', 'vehicle:id,vehicle_id')
            ->first();

        $containers = ContainerStatus::whereIn('id', json_decode($load_on_truck['container_nos']))->get();

        $containertype = ContainerType::where('status', 0)->get();

        $ports = Port::where('status', 0)->get();

        // dd($load_on_truck);

        return view('container-tracking.details', compact('load_on_truck', 'containers', 'containertype', 'ports'));
    }

    public function index_loaded_on_truck()
    {
        // $containerOwners = ContainerOwner::all();
        $container_status = LoadOnTruck::where('is_close', 0)->with('entrybyid:id,name')->get();

        $ports = Port::where('status', 0)->get();
        // dd($containerOwner);
        return view('container-tracking.index-loaded-truck', compact('container_status', 'ports'));
    }

    public function create_loaded_on_truck()
    {
        $containertype = ContainerType::where('status', 0)->get();

        $container_no = ContainerStatus::where('is_close', 0)->where('status', 'IDV - Container Discharged from Vessel')->get();

        $ports = Port::where('status', 0)->get();

        $vehicleMaster = VehicleType::where('status', 0)->get();

        $logisticProviders = LogisticProvider::where('status', 0)->get();

        $vehicles = Vehicles::orderBy('id', 'DESC')->get();

        return view('container-tracking.create-loaded-truck', compact(
            'containertype',
            'container_no',
            'ports',
            'vehicleMaster',
            'logisticProviders',
            'vehicles'
        ));
    }

    public function edit_truck($id)
    {

        $load_on_truck = LoadOnTruck::where('id', $id)
            ->with('entrybyid:id,name', 'port:id,name', 'logistic_provider', 'vehicle_types')
            ->first();

        $container_no = ContainerStatus::whereIn('id', json_decode($load_on_truck['container_nos']))->get();

        $containertype = ContainerType::where('status', 0)->get();

        $ports = Port::where('status', 0)->get();

        $logisticProviders = LogisticProvider::where('status', 0)->get();

        $vehicleMaster = VehicleType::where('status', 0)->get();

        $vehicles = Vehicles::orderBy('id', 'DESC')->get();

        // dd($load_on_truck);

        return view('container-tracking.edit', compact(
            'load_on_truck',
            'container_no',
            'containertype',
            'ports',
            'logisticProviders',
            'vehicleMaster',
            'vehicles'
        ));
    }

    public function track_store(Request $request)
    {
        $request->validate([
            'container_nos' => 'required'
        ]);

        $today = new Carbon();

        $obj['container_nos'] = json_encode($request['container_nos']);
        $obj['status'] = 'IPO - Container Loaded on Truck';
        $obj['date'] = $request['date'] ?? $today->format('Y-m-d');
        $obj['logistic_provider_id'] = $request['logistic_provider_id'] ?? 0;
        $obj['vehicle_id'] = $request['vehicle_id'] ?? 0;
        $obj['vehicle_type'] = $request['vehicle_type'] ?? 0;
        $obj['vehicle_no'] = $request['vehicle_no'];
        $obj['contact_person'] = $request['contact_person'];
        $obj['phone_number'] = $request['phone_number'];
        $obj['vin_no'] = $request['vin_no'];
        $obj['driver_name'] = $request['driver_name'];
        $obj['driver_license'] = $request['driver_license_no'];
        $obj['driver_contact_no'] = $request['driver_contact_no'];
        $obj['location'] = $request['location'];
        $obj['port_id'] = $request['port_id'] ?? 0;

        $container_status = LoadOnTruck::create($obj);

        foreach ($request['container_nos'] as $key => $value) {
            $containers = ContainerStatus::where('id', $value)->first();
            $containers['con_loaded_ontruck'] = $request['date'] ?? Carbon::now();
            $containers['status'] = $container_status['status'];
            $containers->update();
        }

        //Activity
        $activity = new ContainerActivityService;
        $activity->addcontainer_activity($container_status);

        // set session
        Session::flash('success', 'Truck Loaded successfully');

        return redirect()->route('tracking.index')->with('success', 'Truck Loaded successfully');
    }


    public function track_update(Request $request)
    {
        $request->validate([
            'container_nos' => 'required'
        ]);

        $today = new Carbon();

        $obj['container_nos'] = json_encode($request['container_nos']);
        $obj['status'] = 'IPO - Container Loaded on Truck';
        $obj['date'] = $request['date'] ?? $today->format('Y-m-d');
        $obj['logistic_provider_id'] = $request['logistic_provider_id'] ?? 0;
        $obj['vehicle_id'] = $request['vehicle_id'] ?? 0;
        $obj['vehicle_type'] = $request['vehicle_type'] ?? 0;
        $obj['vehicle_no'] = $request['vehicle_no'];
        $obj['contact_person'] = $request['contact_person'];
        $obj['phone_number'] = $request['phone_number'];
        $obj['vin_no'] = $request['vin_no'];
        $obj['driver_name'] = $request['driver_name'];
        $obj['driver_license'] = $request['driver_license_no'];
        $obj['driver_contact_no'] = $request['driver_contact_no'];
        $obj['location'] = $request['location'];
        $obj['port_id'] = $request['port_id'] ?? 0;

        // dd($request['truck_id']);
        $container_status = LoadOnTruck::where('id', $request['truck_id'])->update($obj);

        foreach ($request['container_nos'] as $key => $value) {
            $containers = ContainerStatus::where('id', $value)->first();
            $containers['con_loaded_ontruck'] = $request['date'] ?? Carbon::now();
            // $containers['status']=$container_status['status'];
            $containers->update();
        }

        //Activity
        // $activity=new ContainerActivityService;
        // $activity->addcontainer_activity($container_status);

        // set session
        Session::flash('success', 'Truck Updated successfully');

        return redirect()->route('tracking.index')->with('success', 'Truck Updated successfully');
    }


    public function updateTrackingStatus(Request $request)
    {

        if (is_int($request['container_id'])) {
            $request['container_id'] = strval($request['container_id']);
        }

        // dd($request);
        $container_status = ContainerStatus::where('id', $request['container_id'])->first();

        $load_on_truck = LoadOnTruck::whereJsonContains('container_nos', $request['container_id'])->first();

        // if($load_on_truck==null && $container_status['status']!='Initial Stage'){
        //     Session::flash('error', 'Load your Container on truck');
        //     return Redirect::back();
        // }

        if ($request['status'] == 'IDV - Container Discharged from Vessel')
            $container_status['con_discharged_from_vessel'] = $request['date'];

        if ($request['status'] == 'IPO - Container Loaded on Truck')
            $container_status['con_loaded_ontruck'] = $request['date'];

        if ($request['status'] == 'IPI - Container Arrived at Mega Market')
            $container_status['con_at_mm'] = $request['date'];

        if ($request['status'] == 'ICO - Cargo Unpacked from Container')
            $container_status['cargo_unpacked'] = $request['date'];

        if ($request['status'] == 'MCY - Container now Empty') {
            $container_status['con_empty'] = $request['date'];
            $container_status['is_close'] = 1;
        }

        if ($request['status'] == 'Repositioned Move to MM Container Yard') {
            $con['container_owner_id'] = $container_status['container_owner_id'];
            $con['container_id'] = $container_status['container_no'];
            $con['container_type'] = $container_status['container_type'];
            $con['internal_dimension'] = $container_status['internal_dimension'];
            $con['door_opening'] = $container_status['door_opening'];
            $con['cubic_capacity'] = $container_status['cubic_capacity'];
            $con['cargo_weight'] = $container_status['cargo_weight'];
            $con['container_status'] = $container_status['container_status'];
            $con['container_condition'] = $container_status['container_condition'];

            $containerDetail = ContainerDetail::create($con);

            $pre['order_type'] = 'pre_arrival';
            $pre['date'] = Carbon::parse($request['date'])->format('Y-m-d');
            $pre['logistic_provider_id'] = $load_on_truck['logistic_provider_id'] ?? 0;
            $pre['vehicle_type'] = $load_on_truck['vehicle_type'] ?? 0;
            $pre['contact_person'] = $load_on_truck['contact_person'];
            $pre['phone_number'] = $load_on_truck['phone_number'];
            $pre['driver_contact_no'] = $load_on_truck['driver_contact_no'];
            $pre['driver_name'] = $load_on_truck['driver_name'];
            $pre['driver_license_no'] = $load_on_truck['driver_license'];

            $prearrival = PreArrivalDeparture::create($pre);
            $prearrival['container_detail_ids'] = $containerDetail['id'];
            $prearrival->update();

            $container_status['is_close'] = 1;

            $load_on_truck['is_close'] = 1;
            $load_on_truck->update();
        }

        if ($request['status'] == 'MCY - Container now Empty') {
            $container_status['con_empty'] = $request['date'];
            $container_status['is_close'] = 1;

            // $load_on_truck['is_close']=1;
            // $load_on_truck->update();
        }

        if ($request['status'] == 'Repositioned To') {
            $container_status['con_repositioned'] = $request['date'];

            $obj['location'] = $request['location'];
            $obj['address_1'] = $request['address_1'];
            $obj['address_2'] = $request['address_2'];
            $obj['city'] = $request['city'];
            $obj['province'] = $request['province'];
            $obj['zip_code'] = $request['zip_code'];
            $obj['country'] = $request['country'];
        }

        if ($request['status'] == 'Delivered') {
            // $container_status['delivered']=$request['date'];
            $container_status['is_close'] = 1;
            // $load_on_truck['is_close']=1;
            // $load_on_truck->update();
        }


        $container_status['status'] = $request['status'];
        $container_status->update();

        // Activity
        $obj['status'] = $request['status'];
        $obj['load_on_truck_id'] = 0;
        $obj['date'] = $request['date'];
        $obj['notes'] = $request['notes'];

        // Convert the ID to a JSON array
        $jsonArray = json_encode([$request['container_id']]);
        $obj['container_nos'] = $jsonArray;

        $activity = ContainerActivity::create($obj);

        // set session
        Session::flash('success', 'Status Updated successfully');

        if (isset($request['is_close']) && $request['is_close'] == '1') {

            return redirect()->route('tracking.close_container')->with('success', 'Status Updated successfully');
        } else {
            return redirect()->route('tracking.index')->with('success', 'Status Updated successfully');
        }
    }


    // When Containers Loaded on truck then status changes
    public function updateLoadOnTruckStatus(Request $request)
    {

        // dd("hii");
        $load_on_truck = LoadOnTruck::where('id', $request['load_on_truck_id'])->first();

        // dd(json_decode($load_on_truck['container_nos']));
        foreach (json_decode($load_on_truck['container_nos']) as $key => $containers) {
            // dd($containers);
            $container_status = ContainerStatus::where('id', $containers)->first();

            if ($request['status'] == 'IDV - Container Discharged from Vessel')
                $container_status['con_discharged_from_vessel'] = $request['date'];

            if ($request['status'] == 'IPO - Container Loaded on Truck')
                $container_status['con_loaded_ontruck'] = $request['date'];

            if ($request['status'] == 'IPI - Container Arrived at Mega Market')
                $container_status['con_at_mm'] = $request['date'];

            if ($request['status'] == 'ICO - Cargo Unpacked from Container')
                $container_status['cargo_unpacked'] = $request['date'];

            if ($request['status'] == 'MCY - Container now Empty') {
                $container_status['con_empty'] = $request['date'];
                $container_status['is_close'] = 1;
            }


            if ($request['status'] == 'Repositioned Move to MM Container Yard') {
                $con['container_owner_id'] = $container_status['container_owner_id'];
                $con['container_id'] = $container_status['container_no'];
                $con['container_type'] = $container_status['container_type'];
                $con['internal_dimension'] = $container_status['internal_dimension'];
                $con['door_opening'] = $container_status['door_opening'];
                $con['cubic_capacity'] = $container_status['cubic_capacity'];
                $con['cargo_weight'] = $container_status['cargo_weight'];
                $con['container_status'] = $container_status['container_status'];
                $con['container_condition'] = $container_status['container_condition'];

                $containerDetail = ContainerDetail::create($con);

                $pre['order_type'] = 'pre_arrival';
                $pre['date'] = Carbon::parse($request['date'])->format('Y-m-d');
                $pre['logistic_provider_id'] = $load_on_truck['logistic_provider_id'];
                $pre['vehicle_type'] = $load_on_truck['vehicle_type'];
                $pre['contact_person'] = $load_on_truck['contact_person'];
                $pre['phone_number'] = $load_on_truck['phone_number'];
                $pre['driver_contact_no'] = $load_on_truck['driver_contact_no'];
                $pre['driver_name'] = $load_on_truck['driver_name'];
                $pre['driver_license_no'] = $load_on_truck['driver_license'];

                $prearrival = PreArrivalDeparture::create($pre);
                $prearrival['container_detail_ids'] = $containerDetail['id'];
                $prearrival->update();

                $container_status['is_close'] = 1;

                $load_on_truck['is_close'] = 1;
                $load_on_truck->update();
            }

            if ($request['status'] == 'MCY - Container now Empty') {
                $container_status['con_empty'] = $request['date'];
                $container_status['is_close'] = 1;
            }

            // if($request['status']=='Repositioned To Port'){
            //     $container_status['con_repositioned']=$request['date'];

            //     $obj['location']=$request['location'];
            //     $obj['port_id']=$request['port_id'];
            // }

            if ($request['status'] == 'Repositioned To') {
                $container_status['con_repositioned'] = $request['date'];

                // $obj['location']=$request['location'];
                $obj['address_1'] = $request['address_1'];
                $obj['address_2'] = $request['address_2'];
                $obj['city'] = $request['city'];
                $obj['province'] = $request['province'];
                $obj['zip_code'] = $request['zip_code'];
                $obj['country'] = $request['country'];
                // $obj['port_id']=$request['port_id'];
            }

            if ($request['status'] == 'Delivered') {
                $container_status['delivered'] = $request['date'];
                $container_status['is_close'] = 1;

                $load_on_truck['is_close'] = 1;
                $load_on_truck->update();
            }

            $container_status['status'] = $request['status'];
            $container_status->update();

            // Activity
            $obj['status'] = $request['status'];
            $obj['load_on_truck_id'] = 0;
            $obj['date'] = $request['date'];
            $obj['notes'] = $request['notes'];

            // Convert the ID to a JSON array
            $jsonArray = json_encode([$containers]);
            $obj['container_nos'] = $jsonArray;

            $activity = ContainerActivity::create($obj);
        }
        // set session
        Session::flash('success', 'Status Updated successfully');

        return redirect()->route('tracking.index')->with('success', 'Status Updated successfully');
    }

    public function filter(Request $request)
    {
        // $containerOwners = ContainerOwner::all();
        $container_status = ContainerStatus::where('is_close', 0)->with('entrybyid:id,name', 'container_owner:id,company_name', 'port:id,name');

        if (isset($request['status']) && $request['status'] != '' && $request['status'] != null) {
            $container_status = $container_status->where('status', $request['status']);
        }

        if (isset($request['port_id']) && $request['port_id'] != '' && $request['port_id'] != null) {
            $container_status = $container_status->where('port_id', $request['port_id']);
        }

        if (isset($request['container_no']) && $request['container_no'] != '' && $request['container_no'] != null) {
            $container_status = $container_status->where('container_no', $request['container_no']);
        }

        $container_status = $container_status->orderBy('id', 'desc')->get();

        $ports = Port::where('status', 0)->get();
        // dd($container_status);
        return view('container-status.index', compact('container_status', 'ports'));
    }
}
