<?php

namespace App\Http\Controllers\Api\cms;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\cms\Order;
use App\Models\cms\PreArrivalDeparture;
use App\Models\cms\PlacedDepartureOrder;
use App\Models\cms\ContainerDetail;

class DashboardController extends Controller
{
    public function index(Request $request)
    {
        $orders_pending = Order::where('pid_no', '!=', null)->where('status', 0)
            ->count();
        $orders_completed = Order::where('pid_no', '!=', null)->where('status', 1)
            ->count();

        $pre_arrival = PreArrivalDeparture::where('status', 0)
            ->where('order_type', 'pre_arrival')
            ->count();

        $arrival = PreArrivalDeparture::where('order_type', 'arrival')->where('status', 0)
            ->where('approved', 0)
            ->count();

        $pre_departure = PlacedDepartureOrder::where('status', 0)
            ->where('order_type', 'pre_departure')->count();

        $departure = PlacedDepartureOrder::where('order_type', 'departure')
            ->where('approved', 0)
            ->where('status', 0)
            ->count();

        $approval_arrival = PreArrivalDeparture::where('approved', 0)
            ->where('order_type', 'arrival')->where('status', 1)
            ->count();

        $approval_departure = PlacedDepartureOrder::where('approved', 0)
            ->where('order_type', 'departure')->where('status', 1)
            ->count();

        $inventory_pending = ContainerDetail::where('status', '!=', 'completed')
            ->where('pid_no', '!=', null)
            ->where('did_no', null)
            ->where('status', 'pending')
            ->with('orders', 'orders.arrival', 'orders.arrival.block:id,block_name', 'container_owner:id,company_name')
            ->count();
        $inventory_process = ContainerDetail::where('status', '!=', 'completed')
            ->where('pid_no', '!=', null)
            ->where('did_no', null)
            ->whereIn('status', ['process', 'ongoing'])
            ->with('orders', 'orders.arrival', 'orders.arrival.block:id,block_name', 'container_owner:id,company_name')
            ->count();

        $gatepass_aid = Order::where('pid_no', '!=', null)
            ->count();

        $gatepass_did = Order::whereHas('container_details', function ($q) {
            $q->where('did_no', '!=', null);
        })
            ->where('pid_no', '!=', null)
            ->count();

        return response()->json([
            'success' => true,
            'message' => 'Data retrieved successfully',
            'data' => [
                'pre_arrival' => $pre_arrival,
                'arrival' => $arrival,
                'pre_departure' => $pre_departure,
                'departure' => $departure,
                'approval_arrival' => $approval_arrival,
                'approval_departure' => $approval_departure,
                'orders_pending' => $orders_pending,
                'inventory_pending' => $inventory_pending,
                'inventory_process' => $inventory_process,
                'orders_completed' => $orders_completed,
                'gatepass_aid' => $gatepass_aid,
                'gatepass_did' => $gatepass_did,
            ],
        ], 200);
    }
}
