<?php

namespace App\Http\Controllers\Api\cms;

use Illuminate\Http\Request;
use ZipArchive;
use PDO;

class DatabaseBackupController extends Controller
{
    public function downloadMultipleDatabases() {
        // Array of database configurations
        $databaseConfigs = [
            [
                'host' => '127.0.0.1',
                'database' => 'megamarket_cms',
                'username' => 'megamarket_cms',
                'password' => 'Cmz@2240',
            ],
            [
                'host' => '127.0.0.1',
                'database' => 'megamarket_tms',
                'username' => 'megamarket_tms',
                'password' => 'Mgmts@3845',
            ],
            [
                'host' => '127.0.0.1',
                'database' => 'megamarket_erp',
                'username' => 'megamarket_cms',
                'password' => 'Cmz@2240',
            ],
        ];
        $storagePath = storage_path('app/backup');
        $zipFileName = 'database_backups_' . date('Y-m-d_H-i-s') . '.zip';
        $zipFilePath = $storagePath . DIRECTORY_SEPARATOR . $zipFileName;
        $zip = new ZipArchive();
        if ($zip->open($zipFilePath, ZipArchive::CREATE | ZipArchive::OVERWRITE) === true) {
            foreach ($databaseConfigs as $config) {
                try {
                    // Connect to the database
                    $pdo = new PDO("mysql:host={$config['host']};dbname={$config['database']}", $config['username'], $config['password']);
                    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
                    $backupFileName = $config['database'] . '.sql';
                    $backupFilePath = $storagePath . DIRECTORY_SEPARATOR . $backupFileName;
                    $fileHandle = fopen($backupFilePath, 'w');
                    $tables = $pdo->query("SHOW TABLES")->fetchAll(PDO::FETCH_COLUMN);
                    foreach ($tables as $table) {
                        $structure = $pdo->query("SHOW CREATE TABLE `$table`")->fetch(PDO::FETCH_ASSOC);
                        fwrite($fileHandle, "-- Table structure for $table\n");
                        fwrite($fileHandle, $structure['Create Table'] . ";\n\n");
                        $stmt = $pdo->prepare("SELECT * FROM `$table`");
                        $stmt->execute();
                        $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
                        foreach ($rows as $row) {
                            $quotedRow = array_map(function ($value) use ($pdo) {
                                return $pdo->quote($value);
                            }, $row);
                            fwrite($fileHandle, "INSERT INTO `$table` VALUES (" . implode(', ', $quotedRow) . ");\n");
                        }
                        fwrite($fileHandle, "\n");
                    }
                    fclose($fileHandle);
                    $zip->addFile($backupFilePath, $backupFileName);
                } catch (PDOException $e) {
                    return response()->json([
                        'success' => false,
                        'message' => 'Database connection failed: ' . $e->getMessage(),
                    ]);
                } catch (Exception $e) {
                    return response()->json([
                        'success' => false,
                        'message' => 'An error occurred: ' . $e->getMessage(),
                    ]);
                }
            }
            $zip->close();
            // Download the zip file
            return "generated";
            // return response()->download($zipFilePath)->deleteFileAfterSend(true);
        } else {
            return response()->json([
                'success' => false,
                'message' => 'Failed to create zip archive',
            ]);
        }
    }
}
