<?php

namespace App\Http\Controllers\Api\cms;
use Illuminate\Http\Request;
use App\Models\cms\PreArrivalDeparture;
use App\Models\cms\PlacedDepartureOrder;
use App\Models\cms\Order;
use App\Models\cms\ContainerOwner;
use App\Models\cms\Masters\ContainerType;
use App\Models\cms\LogisticProvider;
use App\Models\cms\Masters\VehicleType;
use App\Models\cms\Yard;
use App\Models\cms\ContainerDetail;

class HomeController extends Controller
{
    public function home(){
        $pre_arrival=PreArrivalDeparture::where('status',0)
            ->where('order_type','pre_arrival')->count();

        $arrival=PreArrivalDeparture::where('order_type','arrival')->where('status',0)
            ->where('approved',0)
            ->count();

        $pre_departure=PlacedDepartureOrder::where('status',0)
            ->where('order_type','pre_departure')->count();

        $departure=PlacedDepartureOrder::where('order_type','departure')
            ->where('approved',0)
            ->where('status',0)
            ->count();

        $inventory_pending=ContainerDetail::where('status','!=','completed')
            ->where('pid_no','!=',null)
            ->where('did_no',null)
            ->count();

        $gatepass_aid = Order::where('pid_no','!=',null)
            ->count();

        $gatepass_did = Order::whereHas('container_details',function ($q){
                $q->where('did_no','!=',null);
            })
            ->where('pid_no','!=',null)
            ->count();

        return view('dashboard.home', compact('pre_arrival','arrival','pre_departure','departure','inventory_pending',
                'gatepass_aid','gatepass_did'));
    }

    public function view($type){
        if($type==1){

            $pre_arrival = PreArrivalDeparture::where('status',0)
                ->where('order_type','pre_arrival')
                ->with('container_details','entrybyid')->get();

            return view('dashboard.view', compact('pre_arrival','type'));

        }else if($type==2){

            $pre_arrival = PreArrivalDeparture::with('orders','orders.container_details','entrybyid')
                ->where('order_type','arrival')->where('status',0)
                ->where('approved',0)
                ->get();
            // return $logisticProviders;00
            return view('dashboard.view', compact('pre_arrival','type'));

        }else if($type==3){

            $pre_arrival = PlacedDepartureOrder::where('status',0)
                ->where('order_type','pre_departure')
                ->with('orders','entrybyid')->get();

            return view('dashboard.view', compact('pre_arrival','type'));

        }else if($type==4){

            $pre_arrival = PlacedDepartureOrder::with('orders','orders.container_owner:id,company_name','entrybyid')
                ->where('order_type','departure')
                ->where('approved',0)
                ->where('status',0)
                ->get();

            return view('dashboard.view', compact('pre_arrival','type'));
        }
    }

    public function createPreArrival($type)
    {
        // dd($type);
        //Orders which are not arrived
        $orders=Order::where('status',0)->where('did_no','=',null)
            ->whereHas('arrival',function($query){
                $query->where('approved',1);
            })->get();

        $containerOwners = ContainerOwner::where('status',0)->get();

        $containertype = ContainerType::where('status',0)->get();

        $logisticProviders = LogisticProvider::where('status',0)->get();

        $vehicleMaster=VehicleType::where('status',0)->get();

        $yards=Yard::where('status',0)->get();

        return view('dashboard.pre_arrival',compact('containerOwners','containertype','logisticProviders','vehicleMaster','yards','orders','type'));
    }


    public function createArrival($type){
        // dd($type);
        //Orders which are not arrived
        $orders=Order::where('status',0)->where('did_no','=',null)
        ->whereHas('arrival',function($query){
            $query->where('approved',1);
        })
        ->get();

        $pre_arrival=PreArrivalDeparture::where('status','pending')
            ->where('status',0)
            ->where('approved',0)
            ->where('order_type','pre_arrival')
            ->get();

        foreach ($pre_arrival as $key => $value) {
            $container_details=ContainerDetail::whereIn('id',explode(',',$value['container_detail_ids']))->get();
            $value['container_details']=$container_details;
        }

        return view('dashboard.arrival',compact('orders','type','pre_arrival'));
    }

    public function approveCreate($id){
        $pre_arrival = PreArrivalDeparture::with('documents')->where('id',$id)->first();
        // dd($logisticProvider);

        $container_details=ContainerDetail::whereIn('id',explode(',',$pre_arrival['container_detail_ids']))->get();

        $containerOwners = ContainerOwner::where('status',0)->get();

        $containertype = ContainerType::where('status',0)->get();

        $logisticProviders = LogisticProvider::where('status',0)->get();

        $vehicleMaster=VehicleType::where('status',0)->get();

        $yards=Yard::where('status',0)->get();

        return view('dashboard.approved_arrival', compact('pre_arrival','containerOwners','containertype','logisticProviders','vehicleMaster','yards','container_details'));
    }

    public function createPreDeparture($type)
    {
        // dd($type);
        //Orders which are not arrived
        $orders=Order::where('status',0)->where('did_no','=',null)
            ->whereHas('arrival',function($query){
                $query->where('approved',1);
            })
            ->get();
        $container_details=ContainerDetail::whereNotIn('status',['completed','process','ongoing'])
            ->where('pid_no','!=',null)
            ->where('did_no',null)
            // ->with('orders','orders.arrival','orders.arrival.block:id,block_name','container_owner:id,company_name')
            ->get();

        $containerOwners = ContainerOwner::where('status',0)->get();

        $containertype = ContainerType::where('status',0)->get();

        $logisticProviders = LogisticProvider::where('status',0)->get();

        $vehicleMaster=VehicleType::where('status',0)->get();

        $yards=Yard::where('status',0)->get();

        return view('dashboard.pre_departure',compact('containerOwners','containertype','logisticProviders','vehicleMaster','yards','orders','type','container_details'));
    }

    public function createDeparture($type)
    {
        $pre_departure=PlacedDepartureOrder::where('status',0)
            ->where('approved',0)
            ->where('order_type','pre_departure')
            ->get();

        foreach ($pre_departure as $key => $value) {
            $container_detail=ContainerDetail::whereIn('id',explode(',',$value['container_detail_ids']))->get();
            $value['container_details']=$container_detail;
        }

        $container_details=ContainerDetail::where('status','pending')
            ->where('order_id','>',0)->get();

        return view('dashboard.departure',compact('type','pre_departure','container_details'));
    }

    public function approveDepartureCreate($id){
        $pre_departure = PlacedDepartureOrder::with('orders','documents')
            ->where('id',$id)
            ->first();
        // dd($logisticProvider);
        $container_details=ContainerDetail::whereIn('id',explode(',',$pre_departure['container_detail_ids']))->get();

        $containerOwners = ContainerOwner::where('status',0)->get();

        $containertype = ContainerType::where('status',0)->get();

        $logisticProviders = LogisticProvider::where('status',0)->get();

        $vehicleMaster=VehicleType::where('status',0)->get();

        return view('dashboard.approved_departure', compact('pre_departure','containerOwners','containertype','logisticProviders','vehicleMaster','container_details'));
    }

    public function inventoryview($type){


            $inventory=ContainerDetail::where('status','!=','completed')
            ->where('pid_no','!=',null)
            ->where('did_no',null)
            ->with('orders','orders.arrival','orders.arrival.block:id,block_name','container_owner:id,company_name','orders.arrival.yard')
            ->get();


        return view('dashboard.inventory', compact('inventory','type'));
    }

    public function fetchOrderByid(Request $request){

        if(isset($request['container_id'])){
            $container_details=ContainerDetail::whereIn('id',$request['container_id'])->get();
            // dd($container_details);
        }

        $type=$request['type'];

        $logisticProviders = LogisticProvider::where('status',0)->get();

        $containerOwners = ContainerOwner::where('status',0)->get();

        $containertype = ContainerType::where('status',0)->get();

        $vehicleMaster=VehicleType::where('status',0)->get();

        // return response()->json(['orders'=>$orders,'container_details'=>$container_details]);
        return view('dashboard.container_details_row', compact('container_details','logisticProviders','containerOwners','containertype','vehicleMaster','type'))->render();
    }

    // Gate Pass
    public function gatepass($type){

        if($type=='aid'){

            $orders = Order::where('pid_no','!=',null)
            ->get();
        }

        if($type=='did'){

            $orders = Order::whereHas('container_details',function ($q){
                    $q->where('did_no','!=',null);
                })
                ->where('pid_no','!=',null)
                ->get();

        }

        $containertype = ContainerType::where('status',0)->get();

        // dd($orders);
        return view('dashboard.gatepass', compact('orders','containertype','type'));
    }
}
