<?php

namespace App\Http\Controllers\Api\cms;

use Illuminate\Http\Request;
use Maatwebsite\Excel\Facades\Excel;
use App\Imports\ArrivalImports;
use App\Imports\ApprovalImports;
use App\Imports\PreDepartureImports;
use App\Imports\ContainerTrackingImport;

class ImportController extends Controller
{

    //  Arrival Imports
    public function import(){
        return view('arrival.import');
    }

    public function uploadImport(Request $request){

        $validator=validator($request->all(),[
            'file' => 'required|mimes:xlsx,xls,csv|max:2048',
        ]);

        if ($validator->fails()) {
            return [
                'success' => false,
                'message' => $validator->errors()->first()
            ];
        } else {

            $file = $request->file('file');

            Excel::import(new ArrivalImports, $file);

            return redirect()->back()->with('success', 'Data imported successfully.');
        }
    }


// Arrival Approval Import To create new Order

    public function importApproval(){
        return view('arrival-approval.import');
    }

    public function uploadImportApproval(Request $request){

        $validator=validator($request->all(),[
            'file' => 'required|mimes:xlsx,xls,csv|max:2048',
        ]);

        if ($validator->fails()) {
            return [
                'success' => false,
                'message' => $validator->errors()->first()
            ];
        } else {

            $file = $request->file('file');

            Excel::import(new ApprovalImports, $file);

            return redirect()->back()->with('success', 'All Data Approved successfully.');
        }
    }

    // Pre Departure Import
    public function importPreDeparture(){
        return view('pre-departure.import');
    }

    public function uploadimportPreDeparture(Request $request){

        $validator=validator($request->all(),[
            'file' => 'required|mimes:xlsx,xls,csv|max:2048',
        ]);

        if ($validator->fails()) {
            return [
                'success' => false,
                'message' => $validator->errors()->first()
            ];
        } else {

            $file = $request->file('file');

            Excel::import(new PreDepartureImports, $file);

            return redirect()->back()->with('success', 'All Data Approved successfully.');
        }
    }

    public function importContainerTracking(){
        return view('container-status.import');
    }

    public function uploadContainerTracking(Request $request){

        $validator=validator($request->all(),[
            'file' => 'required|mimes:xlsx,xls,csv|max:2048',
        ]);

        if ($validator->fails()) {
            return [
                'success' => false,
                'message' => $validator->errors()->first()
            ];
        } else {

            $file = $request->file('file');

            Excel::import(new ContainerTrackingImport, $file);

            return redirect()->back()->with('success', 'All Data Imported successfully.');
        }
    }
}
