<?php

namespace App\Http\Controllers\Api\cms;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use Illuminate\Http\JsonResponse;
use Log;
use Illuminate\Support\Facades\Hash;


class RegisterController extends Controller
{
    /**
     * Register api
     *
     * @return \Illuminate\Http\Response
     */
    // public function register(Request $request): JsonResponse
    // {
    //     $validator = Validator::make($request->all(), [
    //         'name' => 'required',
    //         'email' => 'required|email',
    //         'password' => 'required',
    //         'c_password' => 'required|same:password',
    //     ]);
  
    //     // if ($validator->fails()) {
    //     //     return $this->sendError('Validation Error.', $validator->errors());
    //     // }

    //     $input = $request->all();
    //     $input['password'] = bcrypt($input['password']);
    //     $user = User::create($input);
    //     $success['token'] =  $user->createToken('MyApp')->plainTextToken;
    //     $success['name'] =  $user->name;

    //     return $this->sendResponse($success, 'User register successfully.');
    // }

    /**
     * Login api
     *
     * @return \Illuminate\Http\Response
     */
    // public function login(Request $request): JsonResponse
    // {
    //     if (Auth::attempt(['email' => $request->email, 'password' => $request->password])) {
    //         $user = Auth::user();
    //         $success['access_token'] = $user->createToken('MyApp')->plainTextToken;
    //         $success['name'] = $user->name;
    //         $success['id'] = $user->id;

    //         return response()->json([
    //             'success' => true,
    //             'data'    => $success,
    //             'message' => 'User login successfully.',
    //         ], 200);
    //     } else {
    //         return response()->json([
    //             'success' => false,
    //             'message' => 'Unauthorised.',
    //             'data'    => ['error' => 'Unauthorised'],
    //         ], 401);
    //     }
    // }
    public function login(Request $request){
		
		$response = [
			'access_token'=>null,
			'user'=>null,
			'success' => false,
			'message' => '',
			'redirect'=>'Email is needed'
		];
		$user=array();

		Log::info('Login Attempt');
		Log::info($request);

		if($request['email']!=null && $request['password']!=null){
			
			//check user exists in any organisation
			$user = User::where('email',$request['email'])
				->first();
		}
	
		if($user!=null){	
			if(Hash::check($request['password'], $user->password)){

				$accessToken = $user->createToken('my-app-token')->plainTextToken;

				Auth::login($user);
				$user = User::where('id',$user['id'])->first();
				$response = [
					'access_token'=>$accessToken,
					'user'=>$user,
					'success' => true,
					'message' => 'Login Successfull',
				];
				
			} else {
				$response = [
					'user'=>null,
					'success' => false,
					'message' => 'Password Incorrect',
				];
			}
		}else{
			$response = [
				'user'=>null,
				'success' => false,
				'message' => 'User Not exist',
			];
		}
		
		return response()->json($response);
	}

    /**
     * Logout api
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function logout(Request $request): JsonResponse
    {
        // Get the authenticated user
        $user = Auth::user();

        // Revoke the token that was used during login
        $request->user()->currentAccessToken()->delete();

        // Return a response indicating successful logout
        return $this->sendResponse([], 'User logged out successfully.');
    }


    public function sendResponse($result, $message, $statusCode = 200): JsonResponse
    {
        return response()->json([
            'success' => true,
            'data'    => $result,
            'message' => $message,
        ], $statusCode);
    }
}
