<?php

namespace App\Http\Controllers\Api\cms;
use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use App\Models\cms\PreArrivalDeparture;
use App\Models\cms\Order;
use App\Models\cms\PlacedDepartureOrder;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Session;
use Validator;

class UploadSignatureController extends Controller
{

    public function saveSignatureArrival(Request $request)
    {
        // Validate the request
        $validator = Validator::make($request->all(), [
            'id' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'message' => $validator->errors()->first(),
                'data' => null
            ], 422);
        }
        // dd($request);
        $orders=PreArrivalDeparture::where('id',$request['id'])->first();

        if(!$orders){
            return response()->json([
                'success' => false,
                'message' => "Orders Not Found",
                'data' => null
            ], 422);
        }

        if( $request->input('authorised_sign')){

            $orders['authorised_sign']=$request['authorised_sign']??null;

        }
        if( $request->input('gate_pass_sign') ){

            $orders['gate_pass_sign']=$request['gate_pass_sign']??null;

        }
        if( $request->input('security_sign') ){

            $orders['security_sign']=$request['security_sign']??null;

        }
        if( $request->input('driver_sign') ){

            $orders['driver_sign']=$request['driver_sign']??null;
        }


        $orders->update();

        $response=[
            'success'=>true,
            'message'=>"Sign Uploaded Successfully"
        ];

        return response()->json($response);
    }
    

    public function saveSignatureDeparture(Request $request)
    {
        // Validate the request
        $validator = Validator::make($request->all(), [
            'id' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'message' => $validator->errors()->first(),
                'data' => null
            ], 422);
        }
        // dd($request);
        $orders=PlacedDepartureOrder::where('id',$request['id'])->first();

        if(!$orders){
            return response()->json([
                'success' => false,
                'message' => "Orders Not Found",
                'data' => null
            ], 422);
        }

        if( $request->input('authorised_sign')){

            $orders['authorised_sign']=$request['authorised_sign']??null;

        }
        if( $request->input('gate_pass_sign') ){

            $orders['gate_pass_sign']=$request['gate_pass_sign']??null;

        }
        if( $request->input('security_sign') ){

            $orders['security_sign']=$request['security_sign']??null;

        }
        if( $request->input('driver_sign') ){

            $orders['driver_sign']=$request['driver_sign']??null;
        }


        $orders->update();

        $response=[
            'success'=>true,
            'message'=>"Sign Uploaded Successfully"
        ];

        return response()->json($response);
    }
}
