<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\UserMaster;
// use App\Models\MasterDescription;
use Auth;

class UserMasterController extends Controller
{
    public function createupdate(Request $request){				
		
		$validator=validator($request->all(),[
            'type'=>'required',
            'label'=>'required'
        ]);

        if ($validator->fails()) { 

            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];

        } else {
			if(isset($request['id']) && $request['id']!=0 && $request['id']!=null ){
				$master = UserMaster::findOrFail($request['id']);
				$keys = ['type','label','labelid','value_string','value','sequence','note','software_option'];
				foreach($keys as $k){
					if($request[$k]!=null && $request[$k]!="")
						$master[$k]=$request[$k];
				}
				$master->update();
				$list = UserMaster::where('type',$request['type'])->where('rolledback',0)->get();
			} else {

				if($request['type']>0){

					$labelid=UserMaster::where('type',$request['type'])->where('rolledback',0)->max('labelid');
					$master['labelid']=$labelid+1;

				}else{

					$labelid=UserMaster::where('type',0)->where('rolledback',0)->max('labelid');
					$master['labelid']=$labelid+1;
				}

				$master['type']=$request['type']??0;
				$master['label']=$request['label'];
				
				// $master['sequence']=$request['sequence'];
				$master['value']=$request['value']??0;
				$master['value_string']=$request['value_string'];
                $master['note']=$request['note'];
                $master['software_option']=$request['software_option']??null;
				$master = UserMaster::create($master);
				$list = UserMaster::where('type',$request['type'])->where('rolledback',0)->get();
			}
			return response()->json($list);
		}
	}

    //Getting all masters
    public function fetchrequired(Request $request){
        $user=Auth::user();
        $master = UserMaster::where('rolledback',0);

        if($request['search']!=null && isset($request['search'])){
            $master = $master->where('label','LIKE', '%' . $request['search'] . '%');
        }

		if(isset($request['software_option']) && $request['software_option']!=null && $request['software_option']!=''){
			$master = $master->where('software_option','LIKE', '%' . $request['software_option'] . '%');
		}

        $master = $master->get();

        return response()->json($master);
    }

	public function delete(Request $request){

		$validator=validator($request->all(),[
            'id'=>'required'
        ]);

        if ($validator->fails()) { 

            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];

        } else {

			try{
				$master=UserMaster::findOrFail($request['id']);
				$master['rolledback']=1;
				$master->update();

				$response=[
					'success' => true,
					'message' => 'Data deleted successfully'
				];

				return response()->json($response);

			} catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
                // Return error message in JSON if ID not found
                return response()->json(['success'=>false,'message' => 'Invalid Id to delete '], 404);
            }
		}
	}
}
