<?php
namespace App\Imports;


use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use App\Models\Item;
use Auth;

class ItemExport implements FromCollection , WithHeadings
{
    public function collection()
    {
        $user=Auth::user();

        return Item::where('organisation_id',$user['active_organisation'])
                ->where('is_disabled',0)
                ->select('id','name','sku','hsn_code','price','type','tax_rate','description','active')
                ->get();
    }

    public function headings(): array
    {
        return [
            'ID',
            'Name',
            'SKU',
            'HSN Code',
            'Price',
            'Type',
            'Tax Rate',
            'Description',
            'Active'
        ];
    }
}