<?php
namespace App\Imports;

// use Maatwebsite\Excel\Concerns\Import;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use App\Models\Item; 

class ItemImport implements ToModel, WithHeadingRow
{
    // use Importable;

    public function model(array $rows)
    {   
        // dd($rows);

        $existingItem = Item::where('sku', $rows['sku'])->first();
        

        if($existingItem==null){
            $product = new Item([
                'name' => $rows['name'],
                'sku'=>$rows['sku'],
                'description'=>$rows['description'],
                'price' => $rows['price'],
                'purchase_price'=>$rows['purchase_price'],
                'unit'=>$rows['unit'],
                'tax_rate'=>$rows['tax_rate'],
                'type'=>$rows['type'],
            ]);

            $product->save();
        }
            
    }
}