<?php
namespace App\Imports\Tms;

// use Maatwebsite\Excel\Concerns\Import;
use Illuminate\Support\Collection;
// use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Illuminate\Contracts\Queue\ShouldQueue;
use Maatwebsite\Excel\Concerns\WithChunkReading;
use Maatwebsite\Excel\Concerns\WithBatchInserts;
use Log;
use App\Service\Tms\VehicleTyreService;

class TyreImport implements ToModel, WithHeadingRow ,ShouldQueue,
    WithChunkReading, 
    WithBatchInserts
{
    // use Importable;

    public function model(array $rows)
    {  
        if($rows['tyre_id']==null) return;
        $tyreService=new VehicleTyreService();
        $tyreService->createVehicleTyre($rows);
        
        return null;
    }
    // public function collection(Collection $rows)
    // {
    //     foreach ($rows as $row) {
    //         app(VehicleTyreService::class)->createVehicleTyre($row->toArray());
    //     }
    // }
    public function chunkSize(): int
    {
        return 200;
    }

    public function batchSize(): int
    {
        return 200;
    }
}