<?php

namespace App\Jobs\Naksha;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use App\Models\Dsr;
use App\Models\Invoice;
use App\Models\User;
use App\Service\AccountsTransactionService;
use App\Service\ActivityService;
use App\Service\SequenceService;
use App\Service\SaleItemService;
use App\Service\StaticMaster;
use Carbon\Carbon;
use Log;

class DsrAccounts implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public $dsr;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct(DSR $dsr)
    {
        $this->dsr = $dsr;
    }

    /**
     * Execute the job.
     *
     * @return void
     */

    public function handle(){
        // Calling the Accounts services for account entries
        $today=Carbon::now()->format('Y-m-d');

        Log::info("Dsr TO Invoice Conversion Started");

        $static_service=new StaticMaster;

        // All Services Lists
        $services=['Hotel','Flight','Visa','Assist','CarHire','Insurance','Other','Tour'];

        // Declaring variables
        $total_final_amount=0.0;
        $total_tax_amount=0.0;
        $total_retain_amount=0.0;
        $total_customer_amount=0.0;
        $total_gross_amount=0.0;
        $items=[];


        // Calling all the services in a loop
        foreach ($services as $key => $service) {

            $namespace = 'App\Models';                            // Replace with the actual namespace
            $dsrService = $namespace . '\DsrService' . $service;  //'App/Models/DsrServiceAssist'

            // Getting all the data of single service like Assists, all Assists in a passenger
            $dsr_service=$dsrService::where('dsr_id',$this->dsr->id)
                ->where('is_cancle',0);
            
            //Applying service wise conditions 
            if ($service == 'Hotel') {
                $dsr_service=$dsr_service->with('hotel','room:id,room_number','hotel.country:id,name','hotel.state:id,name','hotel.city:id,name');
            }

            if ($service == 'Visa') {
                $dsr_service=$dsr_service->with('visa_passenger:id,display_name','country:id,name');
            }
            if ($service == 'Insurance') {
                $dsr_service=$dsr_service->with('passenger');
            }
            if ($service == 'Tour') {
                $dsr_service=$dsr_service->with('tour_package');
                // 'tour_package.itinerary','tour_package.itinerary.itinary_rows',
                // 'tour_package.itinerary.itinary_rows','tour_package.itinerary.itinary_rows.accomodation',
                // 'tour_package.itinerary.itinary_rows.destination','tour_package.itinerary.itinary_rows.transport');
            }

            $dsr_service=$dsr_service->get();

            foreach ($dsr_service as $key => $guest_service) {
                $guestIds = explode(',', $guest_service['guest_ids'] ?? '');
                $guest_service['guests']=User::whereIn('id',$guestIds)->get();
            }

            if ($dsr_service->isNotEmpty()) {

                // Reset service amount array for each service
                $service_amount = [
                    'rate' => 0,
                    'tax_rate' => 0,
                    'tax_amount' => 0,
                    'total_amount' => 0
                ];

                // Data exists
                foreach ($dsr_service as $key => $single_service) {

                    // Calculating the total tax amount 
                    $total_tax_amount=$total_tax_amount + $single_service['tax_amount'];    
                    $total_gross_amount=$total_gross_amount + $single_service['gross_amount'];
                    $total_retain_amount=$total_retain_amount + $single_service['retain'];
                    $total_customer_amount=$total_customer_amount + $single_service['customer_amount'];
                    $total_final_amount=$total_final_amount + $single_service['total_amount'];

                    // Calculating single service total amount
                    $service_amount['rate']=$service_amount['rate'] + $single_service['customer_amount'];
                    $service_amount['tax_rate']=$single_service['tax_percent'];
                    $service_amount['tax_amount']=$service_amount['tax_amount'] + $single_service['tax_amount'];
                    $service_amount['total_amount']=$service_amount['total_amount'] + $single_service['total_amount'];
        
                }

                $service_name = strtolower(preg_replace('/([a-z])([A-Z])/', '$1_$2', $service));

                // special exceptions
                if ($service == 'Tour') {
                    $service_name = 'tour_package';
                } elseif ($service == 'CarHire') {
                    $service_name = 'car_hire';
                }

                $single_service['service_name'] = $service_name;

                if($service == 'Other'){
                    // Sale item service
                    $ob['item_id']=$single_service['item_id']??0;
                    $ob['item_name']=$single_service['item_name']??$service;  //Hotel Service
                    $ob['quantity']=$single_service['quantity'];   //count services
                    $ob['unit_id']=0;
                    $ob['rate']=(($service_amount['rate']??0) * ($this->dsr->exchange_rate??1));           //hotel rate (gross_amount)
                    $ob['gross_amount']=(($service_amount['rate']??0)  * ($this->dsr->exchange_rate??1));  //hotel rate (gross_amount)
                    $ob['tax_rate']=($service_amount['tax_rate']??0 ) ;   // tax_percent
                    $ob['tax_amount']=(($service_amount['tax_amount']??0)  * ($this->dsr->exchange_rate??1));   //tax_amount
                    $ob['final_amount']=(($service_amount['total_amount']??0)  * ($this->dsr->exchange_rate??1));  //total_amount
                    $ob['item_remark']=$service.' Service with having no '.$this->dsr->id;   //hotel service 
                    $ob['warehouse']=0;
                    $ob['zone']=0;
                    $ob['rack']=0;
                    $ob['bin']=0;
                    $ob['type']='Product';    //Service
                    $ob['is_service']=1;
                    $ob['service_data']=json_decode($single_service ??'{}',true);

                    array_push($items, $ob); // Push $obj into $items array
                }else{

                    // Sale item service
                    $item_name= $service=='Tour'?'Tour Package':$service;
                    $ob['item_id']=0;
                    $ob['item_name']=$item_name;  //Hotel Service
                    $ob['quantity']=count($dsr_service)??0;   //count services
                    $ob['unit_id']=0;
                    $ob['rate']=(($service_amount['rate']??0) * ($this->dsr->exchange_rate??1));           //hotel rate (gross_amount)
                    $ob['gross_amount']=(($service_amount['rate']??0)  * ($this->dsr->exchange_rate??1));  //hotel rate (gross_amount)
                    $ob['tax_rate']=($service_amount['tax_rate']??0 ) ;   // tax_percent
                    $ob['tax_amount']=(($service_amount['tax_amount']??0)  * ($this->dsr->exchange_rate??1));   //tax_amount
                    $ob['final_amount']=(($service_amount['total_amount']??0)  * ($this->dsr->exchange_rate??1));  //total_amount
                    $ob['item_remark']=$service.' Service with having no '.$this->dsr->id;   //hotel service 
                    $ob['warehouse']=0;
                    $ob['zone']=0;
                    $ob['rack']=0;
                    $ob['bin']=0;
                    $ob['type']='Service';    //Service
                    $ob['is_service']=1;
                    $ob['service_data']=json_decode($single_service ??'{}',true);

                    array_push($items, $ob); // Push ,true$obj into $items array
                }
            }

        }

        $this->dsr['total_tax_amount']=$total_tax_amount;
        $this->dsr['total_retain_amount']=$total_retain_amount;
        $this->dsr['total_gross_amount']=$total_gross_amount;
        $this->dsr['total_final_amount']=$total_final_amount;

        $sequence=new SequenceService;
        $sale_items=new SaleItemService;

        $customer=User::where('id',$this->dsr->customer_id)->first();

        // Invoice Data Entry
        $obj['is_invoice']=1;
        $obj['is_dsr']=1;
        $obj['invoice_id']=$sequence->getSequence('invoice');
        $obj['transaction_date']=$today;   //todays date for the invoice
        $obj['customer_id']=$this->dsr->customer_id;
        $obj['fy']=$static_service->getFinancialYear();
        $obj['customer_type']=$customer['customer_type'];
        $obj['customer_name']=$customer['first_name'].' '.$customer['last_name'];
        $obj['display_name']=$customer['display_name'];
        $obj['phone']=$customer['mobile_no'];
        $obj['email']=$customer['email'];
        $obj['address']=$this->dsr->address;
        $obj['currency']=$this->dsr->currency;
        $obj['currency_symbol']=$this->dsr->currency_symbol;
        $obj['exchange_rate']=$this->dsr->exchange_rate??1;
        $tracking=[
            "module"=>"dsrToInvoice",
            "id"=>$this->dsr->id
        ];
        $obj['tracking_details']=json_encode($tracking);
        $obj['reference_no']=$this->dsr->dsr_no;
        $obj['status']=3;  //Sent For Approval
        
        // Amounts
        $obj['subtotal']=($total_customer_amount * ($this->dsr->exchange_rate??1));       // converting to base currency 
        $obj['total_gross_amount']=($total_customer_amount * ($this->dsr->exchange_rate??1));
        $obj['total_tax']=($total_tax_amount * ($this->dsr->exchange_rate??1));
        $obj['total']=($total_final_amount * ($this->dsr->exchange_rate??1));

        // Creating invoice
        $transaction=Invoice::create($obj);

        Log::info('Dsr To Invoice created ');

        $request['items']=$items;
        $request['sale_type']='invoice';

        // Creating items
        $sale_items->saveItems($request,$transaction);

        Log::info('Dsr To Invoice Items created');

        $this->dsr['is_accounting']=1;
        $this->dsr->save();

        // Update Sequence Number
        $sequence->updateSequence('invoice');

        Log::info('Dsr To Invoice Sequence Updated');
    }
}
