<?php

namespace App\Jobs\Naksha;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use App\Models\Mice;
use App\Models\Invoice;
use App\Models\User;
use App\Service\AccountsTransactionService;
use App\Service\ActivityService;
use App\Service\SequenceService;
use App\Service\SaleItemService;
use App\Service\StaticMaster;
use Carbon\Carbon;
use Log;

class MiceAccounts implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public $mice;
    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct(MICE $mice)
    {
        $this->mice = $mice;
    }

    /**
     * Execute the job.
     *
     * @return void
     */

     public function handle(){
        // Calling the Accounts services for account entries
        $today=Carbon::now()->format('Y-m-d');

        Log::info("Mice TO Invoice Conversion Started");

        $static_service=new StaticMaster;

        // All Services Lists
        $services=['Assist','CarHire','Flight','Hotel','Insurance','Visa','Other','Tour'];

        // Declaring variables
        $total_final_amount=0.0;
        $total_tax_amount=0.0;
        $total_retain_amount=0.0;
        $total_customer_amount=0.0;
        $total_gross_amount=0.0;
        $items=[];


        // Calling all the services in a loop
        foreach ($services as $key => $service) {

            $namespace = 'App\Models';                            // Replace with the actual namespace
            $miceService = $namespace . '\MiceService' . $service;  //'App/Models/DsrServiceAssist'

            // Getting all the data of single service like Assists, all Assists in a passengers
            $mice_service=$miceService::where('mice_id',$this->mice->id)
                ->where('is_cancle',0);

            //Applying service wise conditions 
            if ($service == 'Hotel') {
                $mice_service=$mice_service->with('hotel','room:id,room_number','hotel.country:id,name','hotel.state:id,name','hotel.city:id,name');
            }

            if ($service == 'Visa') {
                $mice_service=$mice_service->with('visa_passenger:id,display_name','country:id,name');
            }
            if ($service == 'Insurance') {
                $mice_service=$mice_service->with('passenger');
            }
            if ($service == 'Tour') {
                $mice_service=$mice_service->with('tour_package','tour_package.itinerary','tour_package.itinerary.itinary_rows',
                'tour_package.itinerary.itinary_rows','tour_package.itinerary.itinary_rows.accomodation',
                'tour_package.itinerary.itinary_rows.destination','tour_package.itinerary.itinary_rows.transport');
            }

            $mice_service=$mice_service->get();

            foreach ($mice_service as $key => $guest_service) {
                $guestIds = explode(',', $guest_service['guest_ids'] ?? '');
                $guest_service['guests']=User::whereIn('id',$guestIds)->get();
            }
            

            if ($mice_service->isNotEmpty()) {

                // Reset service amount array for each service
                $service_amount = [
                    'rate' => 0,
                    'tax_rate' => 0,
                    'tax_amount' => 0,
                    'total_amount' => 0
                ];

                // Data exists
                foreach ($mice_service as $key => $single_service) {

                    // Calculating the total tax amount 
                    $total_tax_amount=$total_tax_amount + $single_service['tax_amount'];    
                    $total_gross_amount=$total_gross_amount + $single_service['gross_amount'];
                    $total_retain_amount=$total_retain_amount + $single_service['retain'];
                    $total_customer_amount=$total_customer_amount + $single_service['customer_amount'];
                    $total_final_amount=$total_final_amount + $single_service['total_amount'];

                    // Calculating single service total amount
                    $service_amount['rate']=$service_amount['rate'] + $single_service['customer_amount'];
                    $service_amount['tax_rate']=$single_service['tax_percent'];
                    $service_amount['tax_amount']=$service_amount['tax_amount'] + $single_service['tax_amount'];
                    $service_amount['total_amount']=$service_amount['total_amount'] + $single_service['total_amount'];
        
                }

                $service_name = strtolower(preg_replace('/([a-z])([A-Z])/', '$1_$2', $service));

                // special exceptions
                if ($service == 'Tour') {
                    $service_name = 'tour_package';
                } elseif ($service == 'CarHire') {
                    $service_name = 'car_hire';
                }

                $single_service['service_name'] = $service_name;
                
                if($service=='Other'){
                    // Sale item service
                    $ob['item_id']=$single_service['item_id']??0;
                    $ob['item_name']=$single_service['item_name']??$service;  //Hotel Service
                    $ob['quantity']=$single_service['quantity']??count($mice_service)??0;   //count services
                    $ob['unit_id']=0;
                    $ob['rate']=(($service_amount['rate']??0) * ($this->mice->exchange_rate??1));           //hotel rate (gross_amount)
                    $ob['gross_amount']=(($service_amount['rate']??0) * ($this->mice->exchange_rate??1));  //hotel rate (gross_amount)
                    $ob['tax_rate']=($service_amount['tax_rate']??0);   // tax_percent
                    $ob['tax_amount']=(($service_amount['tax_amount']??0) * ($this->mice->exchange_rate??1));   //tax_amount
                    $ob['final_amount']=(($service_amount['total_amount']??0) * ($this->mice->exchange_rate??1));  //total_amount
                    $ob['item_remark']=$service.' Mice Service with having no '.$this->mice->mice_no;   //hotel service 
                    $ob['warehouse']=0;
                    $ob['zone']=0;
                    $ob['rack']=0;
                    $ob['bin']=0;
                    $ob['type']='Product';    //Service
                    $ob['is_service']=1;
                    $ob['service_data']=json_decode($single_service ??'{}');

                    array_push($items, $ob); // Push $obj into $items array
                }else{

                    // Sale item service
                    $item_name= $service=='Tour'?'Tour Package':$service;
                    $ob['item_id']=0;
                    $ob['item_name']=$item_name;  //Hotel Service
                    $ob['quantity']=count($mice_service)??0;   //count services
                    $ob['unit_id']=0;
                    $ob['rate']=(($service_amount['rate']??0) * ($this->mice->exchange_rate??1));           //hotel rate (gross_amount)
                    $ob['gross_amount']=(($service_amount['rate']??0) * ($this->mice->exchange_rate??1));  //hotel rate (gross_amount)
                    $ob['tax_rate']=($service_amount['tax_rate']??0);   // tax_percent
                    $ob['tax_amount']=(($service_amount['tax_amount']??0) * ($this->mice->exchange_rate??1));   //tax_amount
                    $ob['final_amount']=(($service_amount['total_amount']??0) * ($this->mice->exchange_rate??1));  //total_amount
                    $ob['item_remark']=$service.' Mice Service with having no '.$this->mice->mice_no;   //hotel service 
                    $ob['warehouse']=0;
                    $ob['zone']=0;
                    $ob['rack']=0;
                    $ob['bin']=0;
                    $ob['type']='Service';    //Service
                    $ob['is_service']=1;
                    $ob['service_data']=json_decode($single_service ??'{}');

                    array_push($items, $ob); // Push $obj into $items array
                }
            }

        }

        $this->mice['total_tax_amount']=$total_tax_amount;
        $this->mice['total_retain_amount']=$total_retain_amount;
        $this->mice['total_gross_amount']=$total_gross_amount;
        $this->mice['total_final_amount']=$total_final_amount;

        $sequence=new SequenceService;
        $sale_items=new SaleItemService;

        $customer=User::where('id',$this->mice->customer_id)->first();

        // Invoice Data Entry
        $obj['is_invoice']=1;
        $obj['is_mice']=1;
        $obj['invoice_id']=$sequence->getSequence('invoice');
        $obj['transaction_date']=$today;   //todays date for the invoice
        $obj['customer_id']=$this->mice->customer_id;
        $obj['fy']=$static_service->getFinancialYear();
        $obj['customer_type']=$customer['customer_type'];
        $obj['customer_name']=$customer['first_name'].' '.$customer['last_name'];
        $obj['display_name']=$customer['display_name'];
        $obj['phone']=$customer['mobile_no'];
        $obj['email']=$customer['email'];
        $obj['address']=$this->mice->address;
        $obj['currency']=$this->mice->currency;
        $obj['exchange_rate']=$this->mice->exchange_rate;
        $obj['currency_symbol']=$this->mice->currency_symbol;
        $tracking=[
            "module"=>"miceToInvoice",
            "id"=>$this->mice->id
        ];
        $obj['tracking_details']=json_encode($tracking);

        // Amounts
        $obj['subtotal']=($total_customer_amount * ($this->mice->exchange_rate??1));       //
        $obj['total_gross_amount']=($total_customer_amount * ($this->mice->exchange_rate??1));
        $obj['total_tax']=($total_tax_amount * ($this->mice->exchange_rate??1));
        $obj['total']=($total_final_amount * ($this->mice->exchange_rate??1));
        $obj['reference_no']=$this->mice->mice_no;
        $obj['status']=3;  //Sent For Approval

        // Creating invoice
        $transaction=Invoice::create($obj);

        Log::info('Mice To Invoice created ');

        $request['items']=$items;
        $request['sale_type']='invoice';

        // Creating items
        $sale_items->saveItems($request,$transaction);

        Log::info('Mice To Invoice Items created');

        $this->mice['is_accounting']=1;
        $this->mice->save();

        // Update Sequence Number
        $sequence->updateSequence('invoice');

        Log::info('Mice To Invoice Sequence Updated');
    }
   
}
