<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Auth;

class Bill extends Model
{
    use HasFactory;

    protected $guarded = [];

    public function items(){
        return $this->hasMany('App\Models\BillItem', 'transaction_id');
    }

    public function vendor(){
        return $this->belongsTo('App\Models\User', 'vendor_id');
    }

    public function activity(){
        return $this->hasMany('App\Models\Activity','module_id')->where('module',"Bill");
    }

    protected static function boot()
    {
        parent::boot();

        Bill::creating(function($model) {
            $user = Auth::user();
            if($user!=null){
                $model->enteredbyid = $user->id;
                // $model->organisation_id = $user->active_organisation;
            }
        });
    }
}
