<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Auth;

class Bom extends Model
{
    use HasFactory;
    protected $guarded = [];

    public function entry_by(){
        return $this->belongsTo('App\Models\User','enteredbyid');
    }

    public function item(){
        return $this->belongsTo('App\Models\Item','item_id');
    }

    public function bom_outcomes(){
        return $this->hasMany('App\Models\BomOutcome','bom_id')->where('rolledback',0);
    }

    public function raw_materials(){
        return $this->hasMany('App\Models\BomRm','bom_id')->where('rolledback',0);
    }

    public function charges(){
        return $this->hasMany('App\Models\BomCharge','bom_id')->where('rolledback',0);
    }
    
    public function packagings(){
        return $this->hasMany('App\Models\BomPackaging','bom_id')->where('rolledback',0);
    }

    public function operations(){
        return $this->hasMany('App\Models\BomOperation','bom_id')->where('rolledback',0);
    }

    public function scraps(){
        return $this->hasMany('App\Models\BomScrap','bom_id')->where('rolledback',0);
    }

    protected static function boot()
    {
        parent::boot();

        Bom::creating(function($model) {
            $user = Auth::user();
            if($user!=null){
                $model->enteredbyid = $user->id;
                // $model->organisation_id = $user->active_organisation;
            }
        });
    }
}
