<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Auth;

class Category extends Model
{
    use HasFactory;
    protected $guarded = [];

    public function activity(){
        return $this->hasMany('App\Models\Activity','module_id')->where('module',"Category");
    }
    public function parent_category(){
        return $this->belongsTo('App\Models\Category','parent_id')->where('is_disabled',0);
    }
    public function sub_category(){
        return $this->hasMany('App\Models\Category','parent_id','id')->where('is_disabled',0);
    }

    protected static function boot()
    {
        parent::boot();

        Category::creating(function($model) {
            $user = Auth::user();
            if($user!=null){
                $model->enteredbyid = $user->id;
                $model->organisation_id = $user->active_organisation;
            }
        });
    }
    
}
