<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Auth;

class CreditNote extends Model
{
    use HasFactory;

    protected $guarded = [];

    public function items(){
        return $this->hasMany('App\Models\CreditNoteItem', 'transaction_id');
    }

    public function customer(){
        return $this->belongsTo('App\Models\User', 'customer_id');
    }
    public function invoice(){
        return $this->belongsTo('App\Models\Invoice', 'invoice_id');
    }

    protected static function boot()
    {
        parent::boot();

        CreditNote::creating(function($model) {
            $user = Auth::user();
            if($user!=null){
                $model->enteredbyid = $user->id;
                $model->organisation_id = $user->active_organisation;
            }
        });
    }
}
