<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Auth;

class DebitNote extends Model
{
    use HasFactory;

    protected $guarded = [];

    public function items(){
        return $this->hasMany('App\Models\DebitNoteItem', 'transaction_id');
    }

    public function vendor(){
        return $this->belongsTo('App\Models\User', 'vendor_id');
    }

    public function bill(){
        return $this->belongsTo('App\Models\Bill', 'bill_id');
    }


    protected static function boot()
    {
        parent::boot();

        DebitNote::creating(function($model) {
            $user = Auth::user();
            if($user!=null){
                $model->enteredbyid = $user->id;
                $model->organisation_id = $user->active_organisation;
            }
        });
    }
}
