<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Auth;

class Dsr extends Model
{
    use HasFactory;

    protected $guarded = [];

    public function customer(){
        return $this->belongsTo('App\Models\User', 'customer_id');
    }

    public function passengers(){
        return $this->hasMany('App\Models\DsrPassenger', 'dsr_id')->where('rolledback',0);
    }
    
    protected static function boot()
    {
        parent::boot();

        Dsr::creating(function($model) {
            $user = Auth::user();
            if($user!=null){
                $model->enteredbyid = $user->id;
                $model->organisation_id = $user->active_organisation;
            }
        });
    }
}
