<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Auth;

class DsrServiceHotel extends Model
{
    use HasFactory;
    protected $guarded = [];

    public function room(){
        return $this->belongsTo('App\Models\Room','room_id');
    }

    public function hotel(){
        return $this->belongsTo('App\Models\Hotel','hotel_id');
    }

    protected static function boot()
    {
        parent::boot();

        DsrServiceHotel::creating(function($model) {
            $user = Auth::user();
            if($user!=null){
                $model->enteredbyid = $user->id;
                $model->organisation_id = $user->active_organisation;
            }
        });
    }
}
