<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Auth;

class DsrServiceVisa extends Model
{
    use HasFactory;

    protected $guarded = [];

    public function visa_passenger(){
        return $this->belongsTo('App\Models\User','passenger_visa_id');
    }

    public function country(){
        return $this->belongsTo('App\Models\Country','country_id');
    }
    
    protected static function boot()
    {
        parent::boot();

        DsrServiceVisa::creating(function($model) {
            $user = Auth::user();
            if($user!=null){
                $model->enteredbyid = $user->id;
                $model->organisation_id = $user->active_organisation;
            }
        });
    }
}
