<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Auth;

class Expense extends Model
{
    use HasFactory;

    protected $guarded = [];

    public function expense_account(){
        return $this->belongsTo('App\Models\Account', 'acc_id');
    }
    public function paid_through(){
        return $this->belongsTo('App\Models\Account', 'paid_by');
    }

    public function expense_head(){
        return $this->belongsTo('App\Models\ExpenseHead', 'expense_head_id','id');
    }

    public function activity(){
        return $this->hasMany('App\Models\Activity','module_id')->where('module',"Expenses");
    }
    
    public function customer(){
        return $this->belongsTo('App\Models\User', 'customer_id');
    }

    public function vendor(){
        return $this->belongsTo('App\Models\User', 'vendor_id');
    }
    


    protected static function boot()
    {
        parent::boot();

        Expense::creating(function($model) {
            $user = Auth::user();
            if($user!=null){
                $model->enteredbyid = $user->id;
                $model->organisation_id = $user->active_organisation;
            }
        });
    }
}
