<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Auth;

class GRN extends Model
{
    use HasFactory;

    protected $guarded = [];

    public function items(){
        return $this->hasMany('App\Models\GRNItems', 'transaction_id');
    }

    public function vendor(){
        return $this->belongsTo('App\Models\User', 'vendor_id');
    }

    public function purchase_order(){
        return $this->belongsTo('App\Models\PurchaseOrder', 'purchase_order_id');
    }

    public function charges_type(){
        return $this->hasMany('App\Models\GRNCharge', 'grn_id');
    }

    public function activity(){
        return $this->hasMany('App\Models\Activity','module_id')->where('module',"Purchase Order");
    }

    protected static function boot()
    {
        parent::boot();

        GRN::creating(function($model) {
            $user = Auth::user();
            if($user!=null){
                $model->enteredbyid = $user->id;
                $model->organisation_id = $user->active_organisation;
            }
        });
    }
}
