<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Auth;

class GRNCharge extends Model
{
    use HasFactory;

    protected $guarded = [];

    public function account(){
        return $this->belongsTo('App\Models\Account','account_id');
    }

    public function vendor(){
        return $this->belongsTo('App\Models\User', 'vendor_id');
    }

    public function entry_by(){
        return $this->belongsTo('App\Models\User','enteredbyid');
    }
    

    protected static function boot()
    {
        parent::boot();

        GRNCharge::creating(function($model) {
            $user = Auth::user();
            if($user!=null){
                $model->enteredbyid = $user->id;
                $model->organisation_id = $user->active_organisation;
            }
        });
    }
}
