<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Auth;

class GRNItems extends Model
{
    use HasFactory;
    protected $guarded = [];

    public function item(){
        return $this->belongsTo('App\Models\Item','item_id')->where('is_disabled',0);
    }

    public function grn(){
        return $this->belongsTo('App\Models\GRN','transaction_id');
    }

    protected static function boot()
    {
        parent::boot();

        GRNItems::creating(function($model) {
            $user = Auth::user();
            if($user!=null){
                $model->enteredbyid = $user->id;
                $model->organisation_id = $user->active_organisation;
            }
        });
    }
}
