<?php

namespace App\Models\Hrms;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Auth;
use App\Models\Hrms\ShiftMaster;
use App\Models\User;

class Attendance extends Model
{
    use HasFactory;
    protected $guarded = [];
    
   
    public function employee()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
    
    public function shiftMaster(){
        return $this->belongsTo(ShiftMaster::class, 'shift_id');
    }

    public function enteredby(){
        return $this->belongsTo('App\Models\User', 'enteredbyid');
    }

    protected static function boot()
    {
        parent::boot();

        Attendance::creating(function($model) {
            $user = Auth::user();
            if($user!=null){
                $model->enteredbyid = $user->id;
                $model->organisation_id = $user->active_organisation;
            }
        });
    }
}
