<?php

namespace App\Models\Hrms;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Auth;
use \App\Models\Hrms\Employee; 
use \App\Models\User; 

class Department extends Model
{
    use HasFactory;

    protected $guarded = [];

    protected static function boot()
    {
        parent::boot();

        Department::creating(function($model) {
            $user = Auth::user();
            if($user!=null){
                $model->enteredbyid = $user->id;
                $model->organisation_id = $user->active_organisation;
            }
        });
    }

    public function enteredby(){
        return $this->belongsTo('App\Models\User', 'enteredbyid');
    }

    public function parentDepartment()
    {
        return $this->belongsTo(Department::class, 'parent_department'); 
    }

    public function departmentHead()
    {
        return $this->belongsTo(User::class, 'department_head');
    }

    public function employees()
    {
        return $this->hasMany(Employee::class, 'department_id');
    }

}
