<?php

namespace App\Models\Hrms;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\User;
use App\Models\Hrms\Experience;
use App\Models\Hrms\Education;
use App\Models\Hrms\Contact;
use App\Models\Hrms\Document;
use App\Models\Hrms\Employee;
use App\Models\Hrms\Designation;
use App\Models\Hrms\Department; 
use App\Models\Hrms\EmployeeHealth; 
use Auth;

class Employee extends Model
{
    use HasFactory;

    protected $guarded = [];

    protected static function boot()
    {
        parent::boot();

        Employee::creating(function($model) {
            $user = Auth::user();
            if($user!=null){
                $model->enteredbyid = $user->id;
                $model->organisation_id = $user->active_organisation;
            }
        });
    }
    

    public function contacts(){
        return $this->hasMany(Contact::class, 'user_id', 'user_id');
    }
    
    public function experiences(){
        return $this->hasMany(Experience::class, 'user_id', 'user_id');
    }

    public function educations(){
        return $this->hasMany(Education::class, 'user_id', 'user_id');
    }

    public function documents(){
        return $this->hasMany(Document::class, 'user_id', 'user_id');
    }

    public function employeeHealth(){
        return $this->belongsTo(EmployeeHealth::class, 'user_id', 'user_id');
    }

    public function department(){
        return $this->belongsTo(Department::class, 'department_id');
    }

    public function designation(){
        return $this->belongsTo(Designation::class, 'designation_id');
    }

    public function reportingManager(){
        return $this->belongsTo(User::class, 'reporting_manager_id');
    }
}
