<?php

namespace App\Models\Hrms;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Hrms\MobileAppUser;

class Followers extends Model
{
    use HasFactory;

    protected $guarded = [];

    protected $table = 'followers';

    // Define the follower relationship
    public function follower()
    {
        return $this->belongsTo(MobileAppUser::class, 'follower_id');
    }

    // Define the user relationship (the user being followed)
    public function user()
    {
        return $this->belongsTo(MobileAppUser::class, 'user_id');
    }
    

}
