<?php

namespace App\Models\Hrms;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Auth;
use \App\Models\Hrms\Designation;
use \App\Models\Hrms\Department;

class JobOpening extends Model
{
    use HasFactory;
 
    protected $guarded = [];
 
    public function department(){
        return $this->belongsTo(Department::class, 'department');
    }

    public function designation(){
        return $this->belongsTo(Designation::class, 'designation');
    }

    public function enteredby(){
        return $this->belongsTo('App\Models\User', 'enteredbyid');
    }

    protected static function boot()
    {
        parent::boot();

        JobOpening::creating(function($model) {
            $user = Auth::user();
            if($user!=null){
                $model->enteredbyid = $user->id;
                $model->organisation_id = $user->active_organisation;
            }
        });
    }
}
