<?php

namespace App\Models\Hrms;

use Illuminate\Database\Eloquent\Factories\HasFactory; 
use Illuminate\Database\Eloquent\Model;
use Auth;
use \App\Models\User; 

class Ticket extends Model
{
    use HasFactory;

    protected $guarded = [];

    public function employee(){
        return $this->belongsTo('App\Models\User','user_id');
    }
    
    public function requestedTo(){
        return $this->belongsTo('App\Models\User','requested_to');
    }

    public function enteredby(){
        return $this->belongsTo('App\Models\User', 'enteredbyid');
    }
   
    
    protected static function boot()
    {
        parent::boot();

        Ticket::creating(function($model) {
            $user = Auth::user();
            if($user!=null){
                $model->enteredbyid = $user->id;
                $model->organisation_id = $user->active_organisation;
            }
        });
    }

   
}

