<?php

namespace App\Models\Hrms;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Auth;

class Trainer extends Model
{
    use HasFactory;

    protected $guarded = [];

    public function enteredby(){
        return $this->belongsTo('App\Models\User', 'enteredbyid');
    }
   
   protected static function boot()
   {
       parent::boot();

       Trainer::creating(function($model) {
           $user = Auth::user();
           if($user!=null){
               $model->enteredbyid = $user->id;
               $model->organisation_id = $user->active_organisation;
           }
       });
   }
}
