<?php

namespace App\Models\Hrms;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Auth;
use App\Models\Hrms\Trainer;
use App\Models\User;

class Training extends Model
{
    use HasFactory;

    protected $guarded = [];

    public function trainer(){
        return $this->belongsTo(Trainer::class, 'trainer_id');
    }
    
    public function employe(){
        return $this->belongsTo(User::class, 'user_id');
    }

    public function enteredby(){
        return $this->belongsTo('App\Models\User', 'enteredbyid');
    }
    

   protected static function boot()
   {
       parent::boot();

       Training::creating(function($model) {
           $user = Auth::user();
           if($user!=null){
               $model->enteredbyid = $user->id;
               $model->organisation_id = $user->active_organisation;
           }
       });
   }
}
