<?php

namespace App\Models\Hrms;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Auth;
use \App\Models\Hrms\Department; 
use \App\Models\Hrms\Employee; 

class Travel extends Model
{
    use HasFactory;
    protected $guarded = [];
    
    protected static function boot()
    {
        parent::boot();

        Travel::creating(function($model) {
            $user = Auth::user();
            if($user!=null){
                $model->enteredbyid = $user->id;
                $model->organisation_id = $user->active_organisation;
            }
        });
    }

    public function department(){
        return $this->belongsTo(Department::class, 'department_id');
    }
    
    public function employee(){
        return $this->belongsTo(Employee::class, 'user_id');
    }
}
