<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Auth;

class Invoice extends Model
{
    use HasFactory;

    protected $guarded = [];

    public function items(){
        return $this->hasMany('App\Models\InvoiceItem', 'transaction_id')->where('is_disabled',0);
    }

    public function customer(){
        return $this->belongsTo('App\Models\User', 'customer_id');
    }

    public function activity(){
        return $this->hasMany('App\Models\Activity','module_id')->where('module',"Invoice");
    }

    public function entry_by(){
        return $this->belongsTo('App\Models\User','enteredbyid');
    }
    

    protected static function boot()
    {
        parent::boot();

        Invoice::creating(function($model) {
            $user = Auth::user();
            if($user!=null){
                $model->enteredbyid = $user->id;
                $model->organisation_id = $user->active_organisation;
            }
        });
    }
}
