<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Auth;

class InvoiceItem extends Model
{
    use HasFactory;

    protected $guarded = [];

    protected $casts = [
        'service_data' => 'array',
    ];

    public function item(){
        return $this->belongsTo('App\Models\Item','item_id');
    }

    public function invoice(){
        return $this->belongsTo('App\Models\Invoice','transaction_id');
    }

    protected static function boot()
    {
        parent::boot();

        InvoiceItem::creating(function($model) {
            $user = Auth::user();
            if($user!=null){
                // $model->enteredbyid = $user->id;
                $model->organisation_id = $user->active_organisation;
            }
        });
    }
}
