<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Cviebrock\EloquentSluggable\Sluggable;
use Auth;

class Item extends Model
{
    use HasFactory;

    protected $guarded = [];

    public function sluggable():array
    {
    	return ['url_name' => ['source' => 'name']];
    }

    public function stock_transaction(){
        return $this->hasMany('App\Models\StockTransaction','item_id');
    }

    // public function preferred_vendor(){
    //     return $this->belongsTo('App\Models\User','preferred_vendor');
    // }

    public function sale_account(){
        return $this->belongsTo('App\Models\Account','sale_acc_id');
    }

    public function purchase_account(){
        return $this->belongsTo('App\Models\Account','purchase_acc_id');
    }

    public function category(){
        return $this->belongsTo('App\Models\Category','category_id');
    }

    public function sub_category(){
        return $this->belongsTo('App\Models\Category','sub_category_id');
    }

    public function activity(){
        return $this->hasMany('App\Models\Activity','module_id')->where('module',"Item");
    }
    
    public function entry_by(){
        return $this->belongsTo('App\Models\User','enteredbyid');
    }

    public function brand(){
        return $this->belongsTo('App\Models\Brand','brand_id');
    }

    // TMS Relations


    public function battery_details(){
        return $this->belongsTo('App\Models\Tms\BatteryDetail','id','item_id');
    }
    public function tyre_details(){
        return $this->belongsTo('App\Models\Tms\TyreDetail','id','item_id');
    }
    public function rim_details(){
        return $this->belongsTo('App\Models\Tms\RimDetail','id','item_id');
    }

    protected static function boot()
    {
        parent::boot();

        Item::creating(function($model) {
            $user = Auth::user();
            if($user!=null){
                $model->enteredbyid = $user->id;
                $model->organisation_id = $user->active_organisation;
            }
        });
    }
}
