<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Auth;

class Itinerary extends Model
{
    use HasFactory;

    protected $guarded = [];

    public function accomodation(){
        return $this->belongsTo('App\Models\Naksha\Accommodation', 'accommodation_id');
    }
    public function destination(){
        return $this->belongsTo('App\Models\Naksha\TourDestination', 'destination_id');
    }
    public function transport(){
        return $this->belongsTo('App\Models\Naksha\TourTravel', 'transport_id');
    }

    public function itinary_rows(){
        return $this->hasMany('App\Models\ItineraryRow', 'itinerary_id');
    }
    
    protected static function boot()
    {
        parent::boot();

        Itinerary::creating(function($model) {
            $user = Auth::user();
            if($user!=null){
                // $model->enteredbyid = $user->id;
                $model->organisation_id = $user->active_organisation;
            }
        });
    }
}
